/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import javax.swing.JComponent;

public class EditorTextFieldWithBrowseButton
extends ComponentWithBrowseButton<EditorTextField>
implements TextAccessor {
    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted) {
        this(project, isClassAccepted, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
    }

    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        super((JComponent)((Object)EditorTextFieldWithBrowseButton.createEditorTextField(project, isClassAccepted, visibilityChecker)), null);
    }

    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        super((JComponent)((Object)EditorTextFieldWithBrowseButton.createEditorTextField(project, isClassAccepted, visibilityChecker, fileType)), null);
    }

    private static EditorTextField createEditorTextField(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        return EditorTextFieldWithBrowseButton.createEditorTextField(project, isClassAccepted, visibilityChecker, (FileType)StdFileTypes.JAVA);
    }

    private static EditorTextField createEditorTextField(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        if (project.isDefault()) {
            return new EditorTextField();
        }
        return new EditorTextField(EditorTextFieldWithBrowseButton.createDocument("", project, isClassAccepted, visibilityChecker), project, fileType);
    }

    private static Document createDocument(String text, Project project, boolean isClassesAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(text, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(visibilityChecker);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        ((EditorTextField)((Object)this.getChildComponent())).setText(text);
    }

    public String getText() {
        return ((EditorTextField)((Object)this.getChildComponent())).getText();
    }
}

