/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchManager;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SwitchManagerAppComponent
extends AnActionListener.Adapter
implements KeyEventDispatcher {
    private final Set<AnAction> switchActions;

    public SwitchManagerAppComponent(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ui/switcher/SwitchManagerAppComponent", "<init>"));
        }
        this.switchActions = new THashSet();
        this.switchActions.add(actionManager.getAction("SwitchUp"));
        this.switchActions.add(actionManager.getAction("SwitchDown"));
        this.switchActions.add(actionManager.getAction("SwitchLeft"));
        this.switchActions.add(actionManager.getAction("SwitchRight"));
        this.switchActions.add(actionManager.getAction("SwitchApply"));
        actionManager.addAnActionListener((AnActionListener)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        Project project = event.getProject();
        if (!(project == null || project.isDisposed() || project.isDefault() || this.switchActions.contains(action))) {
            SwitchManager.getInstance((Project)project).disposeCurrentSession(false);
        }
    }

    @Override
    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        Project project;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/switcher/SwitchManagerAppComponent", "dispatchKeyEvent"));
        }
        if (!QuickAccessSettings.getInstance().isEnabled()) {
            return false;
        }
        Component frame = UIUtil.findUltimateParent((Component)e.getComponent());
        if (frame instanceof IdeFrame && (project = ((IdeFrame)frame).getProject()) != null && !project.isDefault()) {
            return SwitchManager.getInstance((Project)project).dispatchKeyEvent(e);
        }
        return false;
    }
}

