/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorProjectLevelConfigurationManager;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileColors", storages={@Storage(file="$WORKSPACE_FILE$")})
public class FileColorManagerImpl
extends FileColorManager
implements PersistentStateComponent<Element> {
    public static final String FC_ENABLED = "FileColorsEnabled";
    public static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    public static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private FileColorProjectLevelConfigurationManager myProjectLevelConfigurationManager;
    private static final Map<String, Color> ourDefaultColors = ContainerUtil.immutableMapBuilder().put((Object)"Blue", (Object)new JBColor(new Color(14479615), new Color(3950443))).put((Object)"Green", (Object)new JBColor(new Color(231, 250, 219), new Color(0x425444))).put((Object)"Orange", (Object)new JBColor(new Color(246, 224, 202), new Color(8407603))).put((Object)"Rose", (Object)new JBColor(new Color(242, 206, 202), new Color(7225678))).put((Object)"Violet", (Object)new JBColor(new Color(222, 213, 241), new Color(5259607))).put((Object)"Yellow", (Object)new JBColor(new Color(255, 255, 228), new Color(5195832))).build();

    public FileColorManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/tabs/FileColorManagerImpl", "<init>"));
        }
        this.myProject = project;
        this.myModel = new FileColorsModel(project);
    }

    private void initProjectLevelConfigurations() {
        if (this.myProjectLevelConfigurationManager == null) {
            this.myProjectLevelConfigurationManager = (FileColorProjectLevelConfigurationManager)ServiceManager.getService((Project)this.myProject, FileColorProjectLevelConfigurationManager.class);
        }
    }

    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    public void setEnabledForTabs(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
    }

    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    public static boolean _isEnabledForTabs() {
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    public Element getState(boolean shared) {
        Element element = new Element("state");
        this.myModel.save(element, shared);
        return element;
    }

    @Nullable
    public Color getColor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tabs/FileColorManagerImpl", "getColor"));
        }
        Color color = ourDefaultColors.get(name);
        if (color != null) {
            return color;
        }
        if ("ffffe4".equals(name) || "494539".equals(name)) {
            return new JBColor(0xFFFFE4, 4801849);
        }
        if ("e7fadb".equals(name) || "2a3b2c".equals(name)) {
            return new JBColor(15203035, 2767660);
        }
        return ColorUtil.fromHex((String)name, null);
    }

    public Element getState() {
        this.initProjectLevelConfigurations();
        return this.getState(false);
    }

    void loadState(Element state, boolean shared) {
        this.myModel.load(state, shared);
    }

    public Collection<String> getColorNames() {
        ArrayList sorted = ContainerUtil.newArrayList(ourDefaultColors.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    public void loadState(Element state) {
        this.initProjectLevelConfigurations();
        this.loadState(state, false);
    }

    public boolean isColored(@NotNull String scopeName, boolean shared) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/ui/tabs/FileColorManagerImpl", "isColored"));
        }
        return this.myModel.isColored(scopeName, shared);
    }

    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return FileEditorManager.getInstance((Project)this.myProject).isFileOpen(vFile) && !UIUtil.isUnderDarcula() ? LightColors.SLIGHTLY_GREEN : null;
    }

    @Nullable
    public Color getRendererBackground(PsiFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    @Nullable
    public Color getFileColor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/tabs/FileColorManagerImpl", "getFileColor"));
        }
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file);
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/tabs/FileColorManagerImpl", "getFileColor"));
        }
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/ui/tabs/FileColorManagerImpl", "isShared"));
        }
        return this.myModel.isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        FileColorsModel fileColorsModel = this.myModel;
        if (fileColorsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorManagerImpl", "getModel"));
        }
        return fileColorsModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        List<FileColorConfiguration> list = this.myModel.getLocalConfigurations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorManagerImpl", "getApplicationLevelConfigurations"));
        }
        return list;
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myModel.getProjectLevelConfigurations();
    }

    @Nullable
    public static String getColorName(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/ui/tabs/FileColorManagerImpl", "getColorName"));
        }
        for (String name : ourDefaultColors.keySet()) {
            if (!color.equals(ourDefaultColors.get(name))) continue;
            return name;
        }
        return null;
    }

    static String getAlias(String text) {
        if (UIUtil.isUnderDarcula() && text.equals("Yellow")) {
            return "Brown";
        }
        return text;
    }
}

