/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class PatternValuesIndex {
    public static Set<String> buildStringIndex(Collection<ElementPattern<?>> patterns) {
        final THashSet result2 = new THashSet();
        PatternValuesIndex.processStringValues(patterns, new PairProcessor<ElementPattern<?>, Collection<Object>>(){

            public boolean process(ElementPattern<?> elementPattern, Collection<Object> value) {
                for (Object o : value) {
                    if (!(o instanceof String)) continue;
                    result2.add((Object)((String)o));
                }
                return true;
            }
        });
        return result2;
    }

    public static boolean processStringValues(Collection<ElementPattern<?>> patterns, PairProcessor<ElementPattern<?>, Collection<Object>> valueProcessor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        for (ElementPattern<?> next : patterns) {
            stack.add(next);
            while (!stack.isEmpty()) {
                ElementPattern pattern = (ElementPattern)stack.removeFirst();
                ElementPatternCondition patternCondition = pattern.getCondition();
                InitialPatternCondition initialCondition = patternCondition.getInitialCondition();
                if (initialCondition instanceof InitialPatternConditionPlus) {
                    stack.addAll(((InitialPatternConditionPlus)initialCondition).getPatterns());
                }
                for (PatternCondition condition : patternCondition.getConditions()) {
                    if (condition instanceof PatternConditionPlus) {
                        stack.add(((PatternConditionPlus)condition).getValuePattern());
                        continue;
                    }
                    if (!(condition instanceof ValuePatternCondition) || valueProcessor.process(next, (Object)((ValuePatternCondition)condition).getValues())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

