/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.HashImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogHashMapImpl
implements Disposable,
VcsLogHashMap {
    public static final VcsLogHashMap EMPTY = new VcsLogHashMap(){

        @Override
        public int getCommitIndex(@NotNull Hash hash) {
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "getCommitIndex"));
            }
            return 0;
        }

        @Override
        @NotNull
        public Hash getHash(int commitIndex) {
            Hash hash = HashImpl.build("");
            if (hash == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "getHash"));
            }
            return hash;
        }

        @Override
        @Nullable
        public Hash findHashByString(@NotNull String string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/VcsLogHashMapImpl$1", "findHashByString"));
            }
            return null;
        }
    };
    private static final File LOG_CACHE_APP_DIR = new File(new File(PathManager.getSystemPath(), "vcs-log"), "hashes");
    private static final Logger LOG = Logger.getInstance(VcsLogHashMap.class);
    private static final int VERSION = 1;
    private final PersistentEnumerator<Hash> myPersistentEnumerator;

    public VcsLogHashMapImpl(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "<init>"));
        }
        VcsLogHashMapImpl.cleanupOldNaming(project, logProviders);
        String logId = VcsLogHashMapImpl.calcLogId(project, logProviders);
        final File mapFile = new File(LOG_CACHE_APP_DIR, logId + "." + 1);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(LOG_CACHE_APP_DIR, logId));
        }
        Disposer.register((Disposable)project, (Disposable)this);
        this.myPersistentEnumerator = (PersistentEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentEnumerator<Hash>, IOException>(){

            public PersistentEnumerator<Hash> compute() throws IOException {
                return new PersistentEnumerator(mapFile, (KeyDescriptor)new MyHashKeyDescriptor(), Page.PAGE_SIZE);
            }
        }, (File)mapFile);
    }

    @NotNull
    private static String calcLogId(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "calcLogId"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "calcLogId"));
        }
        int hashcode = VcsLogHashMapImpl.calcLogProvidersHash(logProviders);
        String string = project.getLocationHash() + "." + Integer.toHexString(hashcode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "calcLogId"));
        }
        return string;
    }

    private static void cleanupOldNaming(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "cleanupOldNaming"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "cleanupOldNaming"));
        }
        int hashcode = VcsLogHashMapImpl.calcLogProvidersHash(providers);
        String oldLogId = project.getName() + "." + hashcode;
        FileUtil.delete((File)new File(new File(PathManager.getSystemPath(), "vcs-log"), oldLogId));
    }

    private static int calcLogProvidersHash(final @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "calcLogProvidersHash"));
        }
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), (Comparator)new Comparator<VirtualFile>(){

            @Override
            public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/data/VcsLogHashMapImpl$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/data/VcsLogHashMapImpl$3", "compare"));
                }
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return StringUtil.join((Collection)sortedRoots, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile root) {
                return root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName();
            }
        }, (String)".").hashCode();
    }

    @Nullable
    private Hash doGetHash(int index) throws IOException {
        return (Hash)this.myPersistentEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getOrPut"));
        }
        return this.myPersistentEnumerator.enumerate((Object)hash);
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getCommitIndex"));
        }
        try {
            return this.getOrPut(hash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Hash getHash(int commitIndex) {
        Hash hash;
        try {
            Hash hash2 = this.doGetHash(commitIndex);
            if (hash2 == null) {
                throw new RuntimeException("Unknown commit index: " + commitIndex);
            }
            hash = hash2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "getHash"));
        }
        return hash;
    }

    @Override
    @Nullable
    public Hash findHashByString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "findHashByString"));
        }
        final String pHash = string.toLowerCase();
        try {
            return this.findHash(new Condition<Hash>(){

                public boolean value(@NotNull Hash hash) {
                    if (hash == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMapImpl$5", "value"));
                    }
                    return hash.toString().toLowerCase().startsWith(pHash);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void flush() {
        this.myPersistentEnumerator.force();
    }

    public void dispose() {
        try {
            this.myPersistentEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    Hash findHash(final @NotNull Condition<Hash> condition) throws IOException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/VcsLogHashMapImpl", "findHash"));
        }
        final Ref hashRef = Ref.create();
        this.myPersistentEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<Hash>(){

            protected boolean accept(Hash hash) {
                boolean matches = condition.value((Object)hash);
                if (matches) {
                    hashRef.set((Object)hash);
                }
                return matches;
            }
        });
        return (Hash)hashRef.get();
    }

    private static class MyHashKeyDescriptor
    implements KeyDescriptor<Hash> {
        private MyHashKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Hash value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsLogHashMapImpl$MyHashKeyDescriptor", "save"));
            }
            ((HashImpl)value).write(out);
        }

        public Hash read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsLogHashMapImpl$MyHashKeyDescriptor", "read"));
            }
            return HashImpl.read(in);
        }

        public int getHashCode(Hash value) {
            return value.hashCode();
        }

        public boolean isEqual(Hash val1, Hash val2) {
            return val1.equals(val2);
        }
    }
}

