/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.graph.utils.ListenerController;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SetListenerController<Listener>
implements ListenerController<Listener> {
    private final Set<Listener> myListeners = new HashSet();

    @Override
    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/graph/utils/impl/SetListenerController", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/graph/utils/impl/SetListenerController", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void removeAllListeners() {
        this.myListeners.clear();
    }

    public void callListeners(Consumer<Listener> listenerConsumer) {
        for (Listener listener : this.myListeners) {
            listenerConsumer.consume(listener);
        }
    }
}

