/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsUserImpl;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogFilterUi myFilterUi;
    private boolean myAreTheOnlyUsers;

    public MyCommitsHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        this.myAreTheOnlyUsers = false;
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        if (!this.myUiProperties.isHighlightMyCommits()) {
            this.myUiProperties.enableHighlighter("MY_COMMITS", false);
            this.myUiProperties.setHighlightMyCommits(true);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                VcsLogUiImpl logUi;
                if (MyCommitsHighlighter.this.myDataHolder.getProject().isDisposed()) {
                    return;
                }
                VcsLogManager logManager = VcsLogContentProvider.findLogManager(MyCommitsHighlighter.this.myDataHolder.getProject());
                if (logManager != null && (logUi = logManager.getLogUi()) != null) {
                    logUi.addLogListener(new VcsLogListener(){

                        public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                            if (dataPack == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/MyCommitsHighlighter$1$1", "onChange"));
                            }
                            MyCommitsHighlighter.this.myAreTheOnlyUsers = MyCommitsHighlighter.this.areTheOnlyUsers();
                        }
                    });
                }
            }
        });
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        VcsUser currentUser;
        VcsShortCommitDetails details;
        if (!this.myUiProperties.isHighlighterEnabled("MY_COMMITS")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        if (!this.myAreTheOnlyUsers && !this.isFilteredByCurrentUser() && (details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex)) != null && !(details instanceof LoadingDetails) && (currentUser = this.myDataHolder.getCurrentUser().get(details.getRoot())) != null && VcsUserImpl.isSamePerson(currentUser, details.getAuthor())) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.bold();
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    private boolean areTheOnlyUsers() {
        NotNullFunction<VcsUser, String> nameToString = new NotNullFunction<VcsUser, String>(){

            @NotNull
            public String fun(VcsUser user) {
                String string = VcsUserImpl.getNameInStandardForm(user.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$2", "fun"));
                }
                return string;
            }
        };
        HashSet allUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)nameToString));
        HashSet currentUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myDataHolder.getCurrentUser().values(), (Function)nameToString));
        return allUserNames.size() == currentUserNames.size() && currentUserNames.containsAll(allUserNames);
    }

    private boolean isFilteredByCurrentUser() {
        VcsLogUserFilter userFilter = this.myFilterUi.getFilters().getUserFilter();
        if (userFilter == null) {
            return false;
        }
        Collection<String> filterByName = ((VcsLogUserFilterImpl)userFilter).getUserNamesForPresentation();
        return Collections.singleton("me").containsAll(filterByName);
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (uiProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (filterUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            MyCommitsHighlighter myCommitsHighlighter = new MyCommitsHighlighter(logDataHolder, uiProperties, filterUi);
            if (myCommitsHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            return myCommitsHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("My Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getTitle"));
            }
            return "My Commits";
        }
    }
}

