/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import org.jetbrains.annotations.NotNull;

public class XToggleLineBreakpointActionHandler
extends DebuggerActionHandler {
    private final boolean myTemporary;

    public XToggleLineBreakpointActionHandler(boolean temporary) {
        this.myTemporary = temporary;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler", "isEnabled"));
        }
        XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(project, event.getDataContext())) {
            for (XLineBreakpointType breakpointType : breakpointTypes) {
                int line;
                VirtualFile file = position.getFile();
                if (!breakpointType.canPutAt(file, line = position.getLine(), project) && breakpointManager.findBreakpointAtLine(breakpointType, file, line) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler", "perform"));
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        HashSet processedLines = new HashSet();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(project, event.getDataContext())) {
            if (!processedLines.add(position.getLine())) continue;
            XBreakpointUtil.toggleLineBreakpoint(project, position, editor, this.myTemporary, true);
        }
    }
}

