/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.settings.GeneralConfigurableUi;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class XDebuggerConfigurableProvider
extends DebuggerConfigurableProvider {
    XDebuggerConfigurableProvider() {
    }

    @NotNull
    public Collection<? extends Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/xdebugger/impl/settings/XDebuggerConfigurableProvider", "getConfigurables"));
        }
        SmartList list = category == DebuggerSettingsCategory.GENERAL ? new SmartList((Object)SimpleConfigurable.create((String)"debugger.general", (String)"", GeneralConfigurableUi.class, (Getter)new Getter<XDebuggerGeneralSettings>(){

            public XDebuggerGeneralSettings get() {
                return XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings();
            }
        })) : null;
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            Collection configurables = settings.createConfigurables(category);
            if (configurables.isEmpty()) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.addAll(configurables);
        }
        if (category == DebuggerSettingsCategory.ROOT) {
            for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
                Configurable configurable = settings.createConfigurable();
                if (configurable == null) continue;
                if (list == null) {
                    list = new SmartList();
                }
                list.add(configurable);
            }
        }
        List list2 = ContainerUtil.notNullize((List)list);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/XDebuggerConfigurableProvider", "getConfigurables"));
        }
        return list2;
    }

    public void generalApplied(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/xdebugger/impl/settings/XDebuggerConfigurableProvider", "generalApplied"));
        }
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            settings.generalApplied(category);
        }
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/xdebugger/impl/settings/XDebuggerConfigurableProvider", "isTargetedToProduct"));
        }
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            if (!settings.isTargetedToProduct(configurable)) continue;
            return true;
        }
        return super.isTargetedToProduct(configurable);
    }
}

