/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorBase {
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @NotNull
    private final EvaluationMode myMode;
    @Nullable
    private final String myHistoryId;
    @Nullable
    private XSourcePosition mySourcePosition;
    private int myHistoryIndex;
    private final JLabel myChooseFactory;
    private WeakReference<ListPopup> myPopup;

    protected XDebuggerEditorBase(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerEditorsProvider", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        this.myHistoryIndex = -1;
        this.myChooseFactory = new JLabel();
        this.myProject = project;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myMode = mode;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
        this.myChooseFactory.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.language.hint", (Object[])new Object[0]));
        this.myChooseFactory.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)3));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$1", "onClick"));
                }
                ListPopup oldPopup = (ListPopup)SoftReference.dereference((Reference)XDebuggerEditorBase.this.myPopup);
                if (oldPopup != null && !oldPopup.isDisposed()) {
                    oldPopup.cancel();
                    XDebuggerEditorBase.this.myPopup = null;
                    return true;
                }
                ListPopup popup = XDebuggerEditorBase.this.createLanguagePopup();
                popup.showUnderneathOf((Component)XDebuggerEditorBase.this.myChooseFactory);
                XDebuggerEditorBase.this.myPopup = new WeakReference<ListPopup>(popup);
                return true;
            }
        }.installOn((Component)this.myChooseFactory);
    }

    private ListPopup createLanguagePopup() {
        DefaultActionGroup actions = new DefaultActionGroup();
        for (final Language language : this.getEditorsProvider().getSupportedLanguages(this.myProject, this.mySourcePosition)) {
            actions.add(new AnAction(language.getDisplayName(), null, language.getAssociatedFileType().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$2", "actionPerformed"));
                    }
                    XExpression currentExpression = XDebuggerEditorBase.this.getExpression();
                    XDebuggerEditorBase.this.setExpression(new XExpressionImpl(currentExpression.getExpression(), language, currentExpression.getCustomInfo()));
                    XDebuggerEditorBase.this.requestFocusInEditor();
                }
            });
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.getComponent());
        return JBPopupFactory.getInstance().createActionGroupPopup("Choose language", (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    protected JPanel addChooseFactoryLabel(JComponent component, boolean top) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "Center");
        JPanel factoryPanel = new JPanel(new BorderLayout());
        factoryPanel.add((Component)this.myChooseFactory, top ? "North" : "Center");
        panel.add((Component)factoryPanel, "West");
        return panel;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        if (this.mySourcePosition != sourcePosition) {
            this.mySourcePosition = sourcePosition;
            this.setExpression(this.getExpression());
        }
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getMode"));
        }
        return evaluationMode;
    }

    @Nullable
    public abstract Editor getEditor();

    public abstract JComponent getComponent();

    public JComponent getEditorComponent() {
        return this.getComponent();
    }

    protected abstract void doSetText(XExpression var1);

    public void setExpression(@Nullable XExpression text) {
        boolean many;
        Language language;
        if (text == null) {
            XExpression xExpression = text = this.getMode() == EvaluationMode.EXPRESSION ? XExpressionImpl.EMPTY_EXPRESSION : XExpressionImpl.EMPTY_CODE_FRAGMENT;
        }
        if ((language = text.getLanguage()) == null) {
            if (this.mySourcePosition != null) {
                language = XDebuggerEditorBase.getFileTypeLanguage(this.mySourcePosition.getFile().getFileType());
            }
            if (language == null) {
                language = XDebuggerEditorBase.getFileTypeLanguage(this.getEditorsProvider().getFileType());
            }
        }
        text = new XExpressionImpl(text.getExpression(), language, text.getCustomInfo(), this.getMode());
        Collection languages = this.getEditorsProvider().getSupportedLanguages(this.myProject, this.mySourcePosition);
        boolean bl = many = languages.size() > 1;
        if (language != null) {
            this.myChooseFactory.setVisible(many);
        }
        this.myChooseFactory.setVisible(this.myChooseFactory.isVisible() || many);
        if (language != null && language.getAssociatedFileType() != null) {
            Icon icon = language.getAssociatedFileType().getIcon();
            this.myChooseFactory.setIcon(icon);
            this.myChooseFactory.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        }
        this.doSetText(text);
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).getLanguage();
        }
        return null;
    }

    public abstract XExpression getExpression();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public void requestFocusInEditor() {
        JComponent preferredFocusedComponent = this.getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    public List<XExpression> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getExpression());
    }

    private void saveTextInHistory(XExpression text) {
        if (this.myHistoryId != null) {
            boolean update = XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text);
            this.myHistoryIndex = -1;
            if (update) {
                this.onHistoryChanged();
            }
        }
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(XExpression text) {
        return this.getEditorsProvider().createDocument(this.getProject(), text, this.mySourcePosition, this.myMode);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions.size() - 1) {
            ++this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }
}

