/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckValidXmlInScriptBodyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends CheckValidXmlInScriptBodyInspectionBase {
    protected InsertQuotedCharacterQuickFix createFix(PsiElement psiElement, int offsetInElement) {
        return new InsertQuotedCharacterQuickFix(psiElement, offsetInElement);
    }

    private static class InsertQuotedCharacterQuickFix
    extends LocalQuickFixOnPsiElement {
        private final int startInElement;

        public InsertQuotedCharacterQuickFix(PsiElement psiElement, int startInElement) {
            super(psiElement);
            this.startInElement = startInElement;
        }

        @NotNull
        public String getText() {
            String character = this.getXmlCharacter();
            String string = XmlBundle.message((String)"unescaped.xml.character.fix.message", (Object[])new Object[]{character.equals("&") ? XmlBundle.message((String)"unescaped.xml.character.fix.message.parameter", (Object[])new Object[0]) : character});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "invoke"));
            }
            PsiFile psiFile = startElement.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                return;
            }
            TextRange range = startElement.getTextRange();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, psiFile.getVirtualFile(), range.getStartOffset() + this.startInElement);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                return;
            }
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? "&amp;" : "&lt;";
            replacement = startElement.getText().replace(xmlCharacter, replacement);
            InjectedLanguageUtil.getTopLevelEditor(editor).getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.getStartElement().getText().substring(this.startInElement, this.startInElement + 1);
        }
    }
}

