/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CastToConcreteClassInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;
    public boolean ignoreInEquals = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/CastToConcreteClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/CastToConcreteClassInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("cast.to.concrete.class.option", new Object[0]), "ignoreAbstractClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("cast.to.concrete.class.ignore.equals.option", new Object[0]), "ignoreInEquals");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastToConcreteClassVisitor();
    }

    private class CastToConcreteClassVisitor
    extends BaseInspectionVisitor {
        private CastToConcreteClassVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiMethod method;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/CastToConcreteClassInspection$CastToConcreteClassVisitor", "visitTypeCastExpression"));
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, CastToConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            if (CastToConcreteClassInspection.this.ignoreInEquals && MethodUtils.isEquals(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement.getType());
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiMethod method;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"cast".equals(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.Class".equals(className)) {
                return;
            }
            PsiType[] parameters = classType.getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiType parameter = parameters[0];
            if (!ConcreteClassUtil.typeIsConcreteClass(parameter, CastToConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            if (CastToConcreteClassInspection.this.ignoreInEquals && MethodUtils.isEquals(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            this.registerMethodCallError(expression, parameter);
        }
    }
}

