/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FormatDecode {
    private static final String FORMAT_SPECIFIER = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final Validator ALL_VALIDATOR = new AllValidator();
    private static final int LEFT_JUSTIFY = 1;
    private static final int ALTERNATE = 2;
    private static final int PLUS = 4;
    private static final int LEADING_SPACE = 8;
    private static final int ZERO_PAD = 16;
    private static final int GROUP = 32;
    private static final int PARENTHESES = 64;
    private static final int PREVIOUS = 128;

    private FormatDecode() {
    }

    private static int flag(char c) {
        switch (c) {
            case '-': {
                return 1;
            }
            case '#': {
                return 2;
            }
            case '+': {
                return 4;
            }
            case ' ': {
                return 8;
            }
            case '0': {
                return 16;
            }
            case ',': {
                return 32;
            }
            case '(': {
                return 64;
            }
            case '<': {
                return 128;
            }
        }
        throw new IllegalFormatException();
    }

    public static Validator[] decode(String formatString, int argumentCount) {
        ArrayList<Validator> parameters = new ArrayList<Validator>();
        Matcher matcher = fsPattern.matcher(formatString);
        boolean previousAllowed = false;
        int implicit = 0;
        int pos = 0;
        int i = 0;
        while (matcher.find(i)) {
            Validator allowed;
            int start = matcher.start();
            if (start != i) {
                FormatDecode.checkText(formatString.substring(i, start));
            }
            i = matcher.end();
            String specifier = matcher.group();
            String posSpec = matcher.group(1);
            String flags = matcher.group(2);
            String width = matcher.group(3);
            String precision = matcher.group(4);
            String dateSpec = matcher.group(5);
            String spec = matcher.group(6);
            int flagBits = 0;
            for (int j = 0; j < flags.length(); ++j) {
                int bit = FormatDecode.flag(flags.charAt(j));
                if ((flagBits | bit) == flagBits) {
                    throw new IllegalFormatException(specifier);
                }
                flagBits |= bit;
            }
            if (FormatDecode.isAllBitsSet(flagBits, 12) || FormatDecode.isAllBitsSet(flagBits, 17)) {
                throw new IllegalFormatException(specifier);
            }
            if ("n".equals(spec)) {
                if (flagBits == 0 && StringUtil.isEmpty((String)width) && StringUtil.isEmpty((String)precision)) continue;
                throw new IllegalFormatException(specifier);
            }
            if ("%".equals(spec)) {
                if (!FormatDecode.isAnyBitSet(flagBits, -2) && StringUtil.isEmpty((String)precision)) continue;
                throw new IllegalFormatException(specifier);
            }
            if (posSpec != null) {
                if (FormatDecode.isAnyBitSet(flagBits, 128)) {
                    throw new IllegalFormatException(specifier);
                }
                String num = posSpec.substring(0, posSpec.length() - 1);
                pos = Integer.parseInt(num) - 1;
                previousAllowed = true;
            } else if (FormatDecode.isAnyBitSet(flagBits, 128)) {
                if (!previousAllowed) {
                    throw new IllegalFormatException(specifier);
                }
            } else {
                previousAllowed = true;
                pos = implicit++;
            }
            if (dateSpec != null) {
                if (FormatDecode.isAnyBitSet(flagBits, -2) || !StringUtil.isEmpty((String)precision)) {
                    throw new IllegalFormatException(specifier);
                }
                allowed = new DateValidator(specifier);
            } else {
                switch (spec.charAt(0)) {
                    case 'B': 
                    case 'H': 
                    case 'b': 
                    case 'h': {
                        if (FormatDecode.isAnyBitSet(flagBits, -2)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = ALL_VALIDATOR;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (FormatDecode.isAnyBitSet(flagBits, -4)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = ALL_VALIDATOR;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (FormatDecode.isAnyBitSet(flagBits, -2) || !StringUtil.isEmpty((String)precision)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new CharValidator(specifier);
                        break;
                    }
                    case 'd': {
                        if (FormatDecode.isAnyBitSet(flagBits, 2)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'X': 
                    case 'o': 
                    case 'x': {
                        if (FormatDecode.isAnyBitSet(flagBits, 44) || !StringUtil.isEmpty((String)precision)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        if (FormatDecode.isAnyBitSet(flagBits, 96)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (FormatDecode.isAnyBitSet(flagBits, 32)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        if (FormatDecode.isAnyBitSet(flagBits, 2)) {
                            throw new IllegalFormatException(specifier);
                        }
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'f': {
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    default: {
                        throw new IllegalFormatException(specifier);
                    }
                }
            }
            FormatDecode.storeValidator(allowed, pos, parameters, argumentCount);
        }
        if (i < formatString.length() - 1) {
            FormatDecode.checkText(formatString.substring(i));
        }
        return parameters.toArray(new Validator[parameters.size()]);
    }

    private static boolean isAnyBitSet(int value, int mask) {
        return (value & mask) != 0;
    }

    private static boolean isAllBitsSet(int value, int mask) {
        return (value & mask) == mask;
    }

    private static void checkText(String s) {
        if (s.indexOf(37) != -1) {
            throw new IllegalFormatException();
        }
    }

    private static void storeValidator(Validator validator, int pos, ArrayList<Validator> parameters, int argumentCount) {
        if (pos < parameters.size()) {
            Validator existing = parameters.get(pos);
            if (existing == null) {
                parameters.set(pos, validator);
            } else if (existing instanceof MultiValidator) {
                ((MultiValidator)existing).addValidator(validator);
            } else if (existing != validator) {
                MultiValidator multiValidator = new MultiValidator(existing.getSpecifier());
                multiValidator.addValidator(existing);
                multiValidator.addValidator(validator);
                parameters.set(pos, multiValidator);
            }
        } else {
            while (pos > parameters.size() && argumentCount > parameters.size()) {
                parameters.add(null);
            }
            parameters.add(validator);
        }
    }

    static abstract class Validator {
        private final String mySpecifier;

        public Validator(String specifier) {
            this.mySpecifier = specifier;
        }

        public abstract boolean valid(PsiType var1);

        public String getSpecifier() {
            return this.mySpecifier;
        }
    }

    private static class MultiValidator
    extends Validator {
        private final Set<Validator> validators = new HashSet<Validator>(3);

        public MultiValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            for (Validator validator : this.validators) {
                if (validator.valid(type)) continue;
                return false;
            }
            return true;
        }

        public void addValidator(Validator validator) {
            this.validators.add(validator);
        }
    }

    private static class FloatValidator
    extends Validator {
        public FloatValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.DOUBLE.equals((Object)type) || "java.lang.Double".equals(text) || PsiType.FLOAT.equals((Object)type) || "java.lang.Float".equals(text) || "java.math.BigDecimal".equals(text);
        }
    }

    private static class IntValidator
    extends Validator {
        public IntValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.INT.equals((Object)type) || "java.lang.Integer".equals(text) || PsiType.LONG.equals((Object)type) || "java.lang.Long".equals(text) || PsiType.SHORT.equals((Object)type) || "java.lang.Short".equals(text) || PsiType.BYTE.equals((Object)type) || "java.lang.Byte".equals(text) || "java.math.BigInteger".equals(text);
        }
    }

    private static class CharValidator
    extends Validator {
        public CharValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            if (PsiType.CHAR.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.SHORT.equals((Object)type) || PsiType.INT.equals((Object)type)) {
                return true;
            }
            String text = type.getCanonicalText();
            return "java.lang.Character".equals(text) || "java.lang.Byte".equals(text) || "java.lang.Short".equals(text) || "java.lang.Integer".equals(text);
        }
    }

    private static class DateValidator
    extends Validator {
        public DateValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiType.LONG.equals((Object)type) || "java.lang.Long".equals(text) || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Date") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Calendar") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.time.temporal.TemporalAccessor");
        }
    }

    private static class AllValidator
    extends Validator {
        public AllValidator() {
            super("");
        }

        @Override
        public boolean valid(PsiType type) {
            return true;
        }
    }

    public static class IllegalFormatException
    extends RuntimeException {
        public IllegalFormatException(String message) {
            super(message);
        }

        public IllegalFormatException() {
        }
    }
}

