/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneDeclaresCloneNotSupportedInspection
extends BaseInspection {
    private boolean onlyWarnOnProtectedClone = true;

    @NotNull
    public String getID() {
        if ("CloneDoesntDeclareCloneNotSupportedException" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection", "getID"));
        }
        return "CloneDoesntDeclareCloneNotSupportedException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("only.warn.on.protected.clone.methods", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnProtectedClone");
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if (!"onlyWarnOnProtectedClone".equals(option.getAttributeValue("name"))) continue;
            this.onlyWarnOnProtectedClone = Boolean.parseBoolean(option.getAttributeValue("value"));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection", "writeSettings"));
        }
        super.writeSettings(node);
        if (!this.onlyWarnOnProtectedClone) {
            node.addContent(new Element("option").setAttribute("name", "onlyWarnOnProtectedClone").setAttribute("value", String.valueOf(this.onlyWarnOnProtectedClone)));
        }
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CloneDeclaresCloneNotSupportedInspectionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneDeclaresCloneNotSupportedExceptionVisitor();
    }

    private class CloneDeclaresCloneNotSupportedExceptionVisitor
    extends BaseInspectionVisitor {
        private CloneDeclaresCloneNotSupportedExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedExceptionVisitor", "visitMethod"));
            }
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (method.hasModifierProperty("final")) {
                return;
            }
            if (CloneDeclaresCloneNotSupportedInspection.this.onlyWarnOnProtectedClone && method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasInThrows(method, "java.lang.CloneNotSupportedException")) {
                return;
            }
            MethodSignatureBackedByPsiMethod signature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (signature == null) {
                return;
            }
            PsiMethod superMethod = signature.getMethod();
            if (!MethodUtils.hasInThrows(superMethod, "java.lang.CloneNotSupportedException")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class CloneDeclaresCloneNotSupportedInspectionFix
    extends InspectionGadgetsFix {
        private CloneDeclaresCloneNotSupportedInspectionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("clone.doesnt.declare.clonenotsupportedexception.declare.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneDeclaresCloneNotSupportedInspection$CloneDeclaresCloneNotSupportedInspectionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodNameIdentifier.getParent();
            PsiUtil.addException((PsiMethod)method, (String)"java.lang.CloneNotSupportedException");
        }
    }
}

