/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.CloneUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneInNonCloneableClassInspection
extends BaseInspection {
    private boolean onlyWarnOnPublicClone = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        if (aClass.isInterface()) {
            String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.interface.problem.descriptor", className);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.class.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("only.warn.on.public.clone.methods", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnPublicClone");
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if (!"onlyWarnOnPublicClone".equals(option.getAttributeValue("name"))) continue;
            this.onlyWarnOnPublicClone = Boolean.parseBoolean(option.getAttributeValue("value"));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection", "writeSettings"));
        }
        super.writeSettings(node);
        if (!this.onlyWarnOnPublicClone) {
            node.addContent(new Element("option").setAttribute("name", "onlyWarnOnPublicClone").setAttribute("value", String.valueOf(this.onlyWarnOnPublicClone)));
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return DelegatingFixFactory.createMakeCloneableFix((PsiClass)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneInNonCloneableClassVisitor();
    }

    private class CloneInNonCloneableClassVisitor
    extends BaseInspectionVisitor {
        private CloneInNonCloneableClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection$CloneInNonCloneableClassVisitor", "visitMethod"));
            }
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (CloneInNonCloneableClassInspection.this.onlyWarnOnPublicClone && !method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (CloneUtils.isCloneable(containingClass) || CloneUtils.onlyThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, containingClass);
        }
    }
}

