/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BooleanExpressionMayBeConditionalInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.expression.may.be.conditional.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanExpressionMayBeConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanExpressionMayBeConditionalVisitor();
    }

    private static class BooleanExpressionMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private BooleanExpressionMayBeConditionalVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.OROR.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            IElementType lTokenType = lBinaryExpression.getOperationTokenType();
            IElementType rTokenType = rBinaryExpression.getOperationTokenType();
            if (!JavaTokenType.ANDAND.equals(lTokenType) || !JavaTokenType.ANDAND.equals(rTokenType)) {
                return;
            }
            PsiExpression expression1 = ParenthesesUtils.stripParentheses(lBinaryExpression.getLOperand());
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(rBinaryExpression.getLOperand());
            if (expression1 == null || expression2 == null || ParenthesesUtils.stripParentheses(lBinaryExpression.getROperand()) == null || ParenthesesUtils.stripParentheses(rBinaryExpression.getROperand()) == null) {
                return;
            }
            if (EquivalenceChecker.expressionsAreEquivalent(BoolUtils.getNegated(expression1), expression2) && !SideEffectChecker.mayHaveSideEffects(expression2)) {
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (EquivalenceChecker.expressionsAreEquivalent(expression1, BoolUtils.getNegated(expression2)) && !SideEffectChecker.mayHaveSideEffects(expression1)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }
    }

    private static class BooleanExpressionMayBeConditionalFix
    extends InspectionGadgetsFix {
        private BooleanExpressionMayBeConditionalFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            PsiExpression llhs = ParenthesesUtils.stripParentheses(lBinaryExpression.getLOperand());
            PsiExpression lrhs = ParenthesesUtils.stripParentheses(rBinaryExpression.getLOperand());
            if (llhs == null || lrhs == null) {
                return;
            }
            PsiExpression thenExpression = ParenthesesUtils.stripParentheses(lBinaryExpression.getROperand());
            PsiExpression elseExpression = ParenthesesUtils.stripParentheses(rBinaryExpression.getROperand());
            if (thenExpression == null || elseExpression == null) {
                return;
            }
            if (BoolUtils.isNegation(llhs)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(lrhs) + '?' + BooleanExpressionMayBeConditionalFix.getText(elseExpression) + ':' + BooleanExpressionMayBeConditionalFix.getText(thenExpression));
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(llhs) + '?' + BooleanExpressionMayBeConditionalFix.getText(thenExpression) + ':' + BooleanExpressionMayBeConditionalFix.getText(elseExpression));
            }
        }

        private static String getText(@NotNull PsiExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/BooleanExpressionMayBeConditionalInspection$BooleanExpressionMayBeConditionalFix", "getText"));
            }
            return ParenthesesUtils.getText(expression, 15);
        }
    }
}

