/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicPackageDependencyInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cyclic.package.dependency.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dependency/CyclicPackageDependencyInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/dependency/CyclicPackageDependencyInspection", "checkElement"));
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analysisScope", "com/siyeh/ig/dependency/CyclicPackageDependencyInspection", "checkElement"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/siyeh/ig/dependency/CyclicPackageDependencyInspection", "checkElement"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/siyeh/ig/dependency/CyclicPackageDependencyInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        Set<RefPackage> dependencies = DependencyUtils.calculateTransitiveDependenciesForPackage(refPackage);
        Set<RefPackage> dependents = DependencyUtils.calculateTransitiveDependentsForPackage(refPackage);
        HashSet<RefPackage> mutualDependents = new HashSet<RefPackage>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        String packageName = refPackage.getQualifiedName();
        if (numMutualDependents == 1) {
            RefPackage[] packages = mutualDependents.toArray(new RefPackage[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.1.problem.descriptor", packageName, packages[0].getQualifiedName());
        } else if (numMutualDependents == 2) {
            RefPackage[] packages = mutualDependents.toArray(new RefPackage[2]);
            Arrays.sort(packages, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.2.problem.descriptor", packageName, packages[0].getQualifiedName(), packages[1].getQualifiedName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.problem.descriptor", packageName, numMutualDependents);
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }
}

