/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ReplaceInheritanceWithDelegationFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("replace.inheritance.with.delegation.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ReplaceInheritanceWithDelegationFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ReplaceInheritanceWithDelegationFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void doFix(final @NotNull Project project, ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/fixes/ReplaceInheritanceWithDelegationFix", "doFix"));
        }
        PsiElement nameElement = descriptor.getPsiElement();
        final PsiClass aClass = (PsiClass)nameElement.getParent();
        assert (!(aClass instanceof PsiAnonymousClass));
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler anonymousToInner = factory.createInheritanceToDelegationHandler();
        DataManager dataManager = DataManager.getInstance();
        final DataContext dataContext = dataManager.getDataContext();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                anonymousToInner.invoke(project, new PsiElement[]{aClass}, dataContext);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, project.getDisposed());
        }
    }
}

