/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.Consumer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.javadoc.PackageDotHtmlMayBePackageInfoInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDotHtmlMayBePackageInfoInspection
extends PackageDotHtmlMayBePackageInfoInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean packageInfoExists = (Boolean)infos[1];
        if (packageInfoExists) {
            return new DeletePackageDotHtmlFix();
        }
        String aPackage = (String)infos[0];
        return new PackageDotHtmlMayBePackageInfoFix(aPackage);
    }

    private static class PackageDotHtmlMayBePackageInfoFix
    extends InspectionGadgetsFix {
        private final String aPackage;

        public PackageDotHtmlMayBePackageInfoFix(String aPackage) {
            this.aPackage = aPackage;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$PackageDotHtmlMayBePackageInfoFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.convert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$PackageDotHtmlMayBePackageInfoFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(final Project project, ProblemDescriptor descriptor) {
            final PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            final XmlFile xmlFile = (XmlFile)element;
            final PsiDirectory directory = xmlFile.getContainingDirectory();
            if (directory == null) {
                return;
            }
            PsiFile file = directory.findFile("package-info.java");
            if (file != null) {
                return;
            }
            new WriteCommandAction.Simple(project, InspectionGadgetsBundle.message("package.dot.html.convert.command", new Object[0]), new PsiFile[]{file}){

                protected void run() throws Throwable {
                    final PsiJavaFile file = (PsiJavaFile)directory.createFile("package-info.java");
                    CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{file.getVirtualFile()});
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                    String packageInfoText = PackageDotHtmlMayBePackageInfoFix.getPackageInfoText(xmlFile);
                    if (packageInfoText == null) {
                        packageInfoText = xmlFile.getText();
                    }
                    StringBuilder commentText = new StringBuilder("/**\n");
                    String[] lines = StringUtil.splitByLines((String)packageInfoText);
                    boolean appended = false;
                    for (String line : lines) {
                        if (!appended && line.isEmpty()) continue;
                        commentText.append(" * ").append(line).append('\n');
                        appended = true;
                    }
                    commentText.append("*/");
                    PsiDocComment comment = elementFactory.createDocCommentFromText(commentText.toString());
                    if (!PackageDotHtmlMayBePackageInfoFix.this.aPackage.isEmpty()) {
                        PsiPackageStatement packageStatement = elementFactory.createPackageStatement(PackageDotHtmlMayBePackageInfoFix.this.aPackage);
                        PsiElement addedElement = file.add((PsiElement)packageStatement);
                        file.addBefore((PsiElement)comment, addedElement);
                    } else {
                        file.add((PsiElement)comment);
                    }
                    element.delete();
                    if (!PackageDotHtmlMayBePackageInfoFix.this.isOnTheFly()) {
                        return;
                    }
                    AsyncResult dataContextFromFocus = DataManager.getInstance().getDataContextFromFocus();
                    dataContextFromFocus.doWhenDone((Consumer)new Consumer<DataContext>(){

                        public void consume(DataContext dataContext) {
                            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile == null) {
                                return;
                            }
                            editorManager.openFile(virtualFile, true);
                        }
                    });
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }
            }.execute();
        }

        @Nullable
        private static String getPackageInfoText(XmlFile xmlFile) {
            PsiElement[] children2;
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag == null) {
                return null;
            }
            for (PsiElement child : children2 = rootTag.getChildren()) {
                HtmlTag htmlTag;
                String name;
                if (!(child instanceof HtmlTag) || !"body".equalsIgnoreCase(name = (htmlTag = (HtmlTag)child).getName())) continue;
                XmlTagValue value = htmlTag.getValue();
                return value.getText();
            }
            return null;
        }
    }

    private static class DeletePackageDotHtmlFix
    extends InspectionGadgetsFix {
        private DeletePackageDotHtmlFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.delete.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$DeletePackageDotHtmlFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$DeletePackageDotHtmlFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            final PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)element;
            new WriteCommandAction.Simple(project, InspectionGadgetsBundle.message("package.dot.html.delete.command", new Object[0]), new PsiFile[]{xmlFile}){

                protected void run() throws Throwable {
                    element.delete();
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }
            }.execute();
        }
    }
}

