/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.TeardownCallsSuperTeardownInspection;
import org.jetbrains.annotations.NotNull;

public class SetupCallsSuperSetupInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SetUpDoesntCallSuperSetUp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SetupCallsSuperSetupInspection", "getID"));
        }
        return "SetUpDoesntCallSuperSetUp";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("setup.calls.super.setup.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SetupCallsSuperSetupInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("setup.calls.super.setup.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SetupCallsSuperSetupInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperSetUpCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownCallsSuperTeardownInspection.TeardownCallsSuperTeardownVisitor("setUp");
    }

    private static class AddSuperSetUpCall
    extends InspectionGadgetsFix {
        private AddSuperSetUpCall() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SetupCallsSuperSetupInspection$AddSuperSetUpCall", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("setup.calls.super.setup.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SetupCallsSuperSetupInspection$AddSuperSetUpCall", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement newStatement = factory.createStatementFromText("super.setUp();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            PsiJavaToken brace = body.getLBrace();
            body.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

