/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final int myLimit;
    private int m_maximumDepth;
    private int m_currentDepth;
    private final Set<PsiElement> scopeEntered = new THashSet();

    public NestingDepthVisitor(int limit) {
        this.myLimit = limit;
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitAnonymousClass"));
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        boolean isAlreadyCounted;
        PsiElement parent = statement.getParent();
        boolean bl = isAlreadyCounted = parent instanceof PsiDoWhileStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiIfStatement || parent instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitBlockStatement(statement);
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitDoWhileStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitDoWhileStatement(statement);
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitForStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitForStatement(statement);
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        PsiStatement elseBranch;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitIfStatement"));
        }
        boolean isAlreadyCounted = false;
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement && statement.equals(elseBranch = ((PsiIfStatement)parent).getElseBranch())) {
            isAlreadyCounted = true;
        }
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitIfStatement(statement);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitSynchronizedStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitSynchronizedStatement(statement);
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitTryStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitTryStatement(statement);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitSwitchStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitSwitchStatement(statement);
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitWhileStatement"));
        }
        this.enterScope((PsiElement)statement);
        super.visitWhileStatement(statement);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "elementFinished"));
        }
        this.exitScope(element);
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
        if (this.m_maximumDepth > this.myLimit) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.m_currentDepth;
        }
    }

    int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

