/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.TObjectIntHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitNumericConversionInspection
extends BaseInspection {
    private static final TObjectIntHashMap<PsiType> typePrecisions = new TObjectIntHashMap(7);
    public boolean ignoreWideningConversions = false;
    public boolean ignoreCharConversions = false;
    public boolean ignoreConstantConversions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ImplicitNumericConversionInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.widening.conversion.option", new Object[0]), "ignoreWideningConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.char.conversion.option", new Object[0]), "ignoreCharConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.constant.conversion.option", new Object[0]), "ignoreConstantConversions");
        return optionsPanel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[1];
        PsiType expectedType = (PsiType)infos[2];
        String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.problem.descriptor", type.getPresentableText(), expectedType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ImplicitNumericConversionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitNumericConversionVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ImplicitNumericConversionFix((PsiExpression)infos[0], (PsiType)infos[2]);
    }

    static boolean hasLowerPrecision(PsiType expressionType, PsiType expectedType) {
        int castPrecision;
        int operandPrecision = typePrecisions.get((Object)expressionType);
        return operandPrecision <= (castPrecision = typePrecisions.get((Object)expectedType));
    }

    static {
        typePrecisions.put((Object)PsiType.BYTE, 1);
        typePrecisions.put((Object)PsiType.CHAR, 2);
        typePrecisions.put((Object)PsiType.SHORT, 2);
        typePrecisions.put((Object)PsiType.INT, 3);
        typePrecisions.put((Object)PsiType.LONG, 4);
        typePrecisions.put((Object)PsiType.FLOAT, 5);
        typePrecisions.put((Object)PsiType.DOUBLE, 6);
    }

    private class ImplicitNumericConversionVisitor
    extends BaseInspectionVisitor {
        private ImplicitNumericConversionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            PsiType expressionType;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreConstantConversions) {
                PsiExpression rootExpression = expression;
                while (rootExpression instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)rootExpression;
                    rootExpression = parenthesizedExpression.getExpression();
                }
                if (rootExpression instanceof PsiLiteralExpression || PsiUtil.isConstantExpression((PsiExpression)rootExpression)) {
                    return;
                }
            }
            if ((expressionType = expression.getType()) == null || !ClassUtils.isPrimitiveNumericType(expressionType)) {
                return;
            }
            if (PsiType.CHAR.equals((Object)expressionType) && (ImplicitNumericConversionInspection.this.ignoreCharConversions || this.isArgumentOfStringIndexOf(parent))) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (!ClassUtils.isPrimitiveNumericType(expectedType)) {
                return;
            }
            if (expressionType.equals(expectedType)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreWideningConversions && ImplicitNumericConversionInspection.hasLowerPrecision(expressionType, expectedType)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreCharConversions && PsiType.CHAR.equals((Object)expectedType)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, expressionType, expectedType);
        }

        private boolean isArgumentOfStringIndexOf(PsiElement parent) {
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"indexOf".equals(methodName) && !"lastIndexOf".equals(methodName)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }
    }

    private static class ImplicitNumericConversionFix
    extends InspectionGadgetsFix {
        private final String m_name;

        ImplicitNumericConversionFix(PsiExpression expression, PsiType expectedType) {
            this.m_name = ImplicitNumericConversionFix.isConvertible(expression, expectedType) ? InspectionGadgetsBundle.message("implicit.numeric.conversion.convert.quickfix", expectedType.getCanonicalText()) : InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (expectedType == null) {
                return;
            }
            if (ImplicitNumericConversionFix.isConvertible(expression, expectedType)) {
                String newExpression = ImplicitNumericConversionFix.convertExpression(expression, expectedType);
                if (newExpression == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression(expression, newExpression);
            } else {
                String newExpression = ParenthesesUtils.getPrecedence(expression) <= 4 ? '(' + expectedType.getCanonicalText() + ')' + expression.getText() : '(' + expectedType.getCanonicalText() + ")(" + expression.getText() + ')';
                PsiReplacementUtil.replaceExpression(expression, newExpression);
            }
        }

        @Nullable
        @NonNls
        private static String convertExpression(PsiExpression expression, PsiType expectedType) {
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return null;
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.LONG)) {
                return expression.getText() + 'L';
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.FLOAT)) {
                return expression.getText() + ".0F";
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.DOUBLE)) {
                return expression.getText() + ".0";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.FLOAT)) {
                String text = expression.getText();
                int length = text.length();
                return text.substring(0, length - 1) + ".0F";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.DOUBLE)) {
                String text = expression.getText();
                int length = text.length();
                return text.substring(0, length - 1) + ".0";
            }
            if (expressionType.equals(PsiType.DOUBLE) && expectedType.equals(PsiType.FLOAT)) {
                int length;
                String text = expression.getText();
                if (text.charAt((length = text.length()) - 1) == 'd' || text.charAt(length - 1) == 'D') {
                    return text.substring(0, length - 1) + 'F';
                }
                return text + 'F';
            }
            if (expressionType.equals(PsiType.FLOAT) && expectedType.equals(PsiType.DOUBLE)) {
                String text = expression.getText();
                int length = text.length();
                return text.substring(0, length - 1);
            }
            return null;
        }

        private static boolean isConvertible(PsiExpression expression, PsiType expectedType) {
            if (!(expression instanceof PsiLiteralExpression) && !ImplicitNumericConversionFix.isNegatedLiteral(expression)) {
                return false;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return false;
            }
            if (ImplicitNumericConversionInspection.hasLowerPrecision(expectedType, expressionType)) {
                return false;
            }
            if (ImplicitNumericConversionFix.isIntegral(expressionType) && ImplicitNumericConversionFix.isIntegral(expectedType)) {
                return true;
            }
            if (ImplicitNumericConversionFix.isIntegral(expressionType) && ImplicitNumericConversionFix.isFloatingPoint(expectedType)) {
                return true;
            }
            return ImplicitNumericConversionFix.isFloatingPoint(expressionType) && ImplicitNumericConversionFix.isFloatingPoint(expectedType);
        }

        private static boolean isNegatedLiteral(PsiExpression expression) {
            if (!(expression instanceof PsiPrefixExpression)) {
                return false;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(tokenType)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return operand instanceof PsiLiteralExpression;
        }

        private static boolean isIntegral(@Nullable PsiType expressionType) {
            return PsiType.INT.equals((Object)expressionType) || PsiType.LONG.equals((Object)expressionType);
        }

        private static boolean isFloatingPoint(@Nullable PsiType expressionType) {
            return PsiType.FLOAT.equals((Object)expressionType) || PsiType.DOUBLE.equals((Object)expressionType);
        }
    }
}

