/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.ReplaceConditionalWithIfPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConditionalWithIfIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceConditionalWithIfIntention.class.getName()));

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceConditionalWithIfPredicate replaceConditionalWithIfPredicate = new ReplaceConditionalWithIfPredicate();
        if (replaceConditionalWithIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "getElementPredicate"));
        }
        return replaceConditionalWithIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "processIntention"));
        }
        PsiConditionalExpression expression = (PsiConditionalExpression)element;
        ReplaceConditionalWithIfIntention.replaceConditionalWithIf(expression);
    }

    private static void replaceConditionalWithIf(PsiConditionalExpression expression) throws IncorrectOperationException {
        PsiStatement statement;
        PsiElement expressionParent = expression.getParent();
        if (expressionParent instanceof PsiLambdaExpression) {
            PsiElement codeBlock = ((PsiLambdaExpression)RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiElement)expression)).getBody();
            LOG.assertTrue(codeBlock instanceof PsiCodeBlock, (Object)codeBlock);
            PsiStatement statement2 = ((PsiCodeBlock)codeBlock).getStatements()[0];
            expression = (PsiConditionalExpression)(statement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement2).getReturnValue() : ((PsiExpressionStatement)statement2).getExpression());
        }
        if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class)) == null) {
            return;
        }
        PsiVariable variable = statement instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiVariable.class) : null;
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        PsiExpression condition = expression.getCondition();
        PsiExpression strippedCondition = ParenthesesUtils.stripParentheses(condition);
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        if (strippedCondition != null) {
            newStatement.append(strippedCondition.getText());
        }
        newStatement.append(')');
        if (variable != null) {
            int conditionIdx;
            String name = variable.getName();
            newStatement.append(name);
            newStatement.append('=');
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression)) >= 0) {
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)(initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType())))).getArrayInitializer();
                LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                expression = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                thenExpression = expression.getThenExpression();
                elseExpression = expression.getElseExpression();
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiElement)expression, thenExpression, newStatement);
            newStatement.append("; else ");
            newStatement.append(name);
            newStatement.append('=');
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiElement)expression, elseExpression, newStatement);
            newStatement.append(';');
            initializer.delete();
            PsiManager manager = statement.getManager();
            Project project = manager.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement ifStatement = factory.createStatementFromText(newStatement.toString(), (PsiElement)statement);
            PsiElement parent = statement.getParent();
            PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            styleManager.reformat(addedElement);
        } else {
            boolean addBraces;
            boolean bl = addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
            if (addBraces || thenExpression == null) {
                newStatement.append('{');
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement, (PsiElement)expression, thenExpression, newStatement);
            if (addBraces) {
                newStatement.append("} else {");
            } else {
                if (thenExpression == null) {
                    newStatement.append('}');
                }
                newStatement.append(" else ");
                if (elseExpression == null) {
                    newStatement.append('{');
                }
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement, (PsiElement)expression, elseExpression, newStatement);
            if (addBraces || elseExpression == null) {
                newStatement.append('}');
            }
            PsiReplacementUtil.replaceStatement(statement, newStatement.toString());
        }
    }

    private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiElement elementToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        if (elementToReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToReplace", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementTextWithoutParentheses"));
        }
        PsiElement expressionParent = elementToReplace.getParent();
        if (expressionParent instanceof PsiParenthesizedExpression) {
            PsiElement grandParent = expressionParent.getParent();
            if (replacementExpression == null || !(grandParent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(replacementExpression, (PsiExpression)grandParent, false)) {
                ReplaceConditionalWithIfIntention.appendElementText(element, expressionParent, replacementExpression, out);
                return;
            }
        }
        ReplaceConditionalWithIfIntention.appendElementText(element, elementToReplace, replacementExpression, out);
    }

    private static void appendElementText(@NotNull PsiElement element, @NotNull PsiElement elementToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (elementToReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToReplace", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention", "appendElementText"));
        }
        if (element.equals(elementToReplace)) {
            String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
            out.append(replacementText);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            PsiComment comment;
            IElementType tokenType;
            out.append(element.getText());
            if (element instanceof PsiComment && (tokenType = (comment = (PsiComment)element).getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
                out.append('\n');
            }
            return;
        }
        for (PsiElement child : children2) {
            ReplaceConditionalWithIfIntention.appendElementText(child, elementToReplace, replacementExpression, out);
        }
    }
}

