/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.MulticatchPredicate;
import org.jetbrains.annotations.NotNull;

public class SplitMultiCatchIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MulticatchPredicate multicatchPredicate = new MulticatchPredicate();
        if (multicatchPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/SplitMultiCatchIntention", "getElementPredicate"));
        }
        return multicatchPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/SplitMultiCatchIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)parent;
        PsiElement grandParent = catchSection.getParent();
        if (!(grandParent instanceof PsiTryStatement)) {
            return;
        }
        PsiParameter parameter = catchSection.getParameter();
        if (parameter == null) {
            return;
        }
        PsiType type = parameter.getType();
        if (!(type instanceof PsiDisjunctionType)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        for (PsiType disjunction : ((PsiDisjunctionType)type).getDisjunctions()) {
            PsiCatchSection copy = (PsiCatchSection)catchSection.copy();
            PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.assertNotNull((Object)((PsiParameter)ObjectUtils.assertNotNull((Object)copy.getParameter())).getTypeElement());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(disjunction.getCanonicalText(true), (PsiElement)catchSection);
            PsiElement replaced = typeElement.replace((PsiElement)newTypeElement);
            grandParent.addBefore((PsiElement)copy, (PsiElement)catchSection);
            styleManager.shortenClassReferences(replaced);
        }
        catchSection.delete();
    }
}

