/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.thumbnail.ThumbnailManager;
import org.intellij.images.thumbnail.ThumbnailView;

public final class ShowThumbnailsAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file != null && file.isDirectory()) {
            ThumbnailManager thumbnailManager = ThumbnailManager.getManager(project);
            ThumbnailView thumbnailView = thumbnailManager.getThumbnailView();
            thumbnailView.setRoot(file);
            thumbnailView.setVisible(true);
            thumbnailView.activate();
        }
    }

    public void update(AnActionEvent e) {
        boolean isEnabled;
        super.update(e);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = isEnabled = file != null && file.isDirectory();
        if (e.getPlace().equals("ProjectViewPopup")) {
            e.getPresentation().setVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }
}

