/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Div;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.Include;
import org.intellij.plugins.relaxNG.model.Pattern;
import org.intellij.plugins.relaxNG.model.Ref;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionResolver
extends CommonElement.Visitor
implements CachedValueProvider<Map<String, Set<Define>>>,
Factory<Set<Define>> {
    private static final Key<CachedValue<Map<String, Set<Define>>>> KEY = Key.create((String)"CACHED_DEFINES");
    private static final ThreadLocal<Set<PsiFile>> myVisitedFiles = new ThreadLocal();
    private static final ThreadLocal<Map<String, Set<Define>>> myDefines = new ThreadLocal<Map<String, Set<Define>>>(){

        @Override
        protected Map<String, Set<Define>> initialValue() {
            return ContainerUtil.newHashMap();
        }
    };
    private final Grammar myScope;

    private DefinitionResolver(Grammar scope) {
        this.myScope = scope;
    }

    @Override
    public void visitInclude(Include include) {
        include.acceptChildren(this);
        PsiFile value = include.getInclude();
        if (myVisitedFiles.get() == null) {
            myVisitedFiles.set((Set<PsiFile>)ContainerUtil.newIdentityTroveSet());
        }
        if (value != null && myVisitedFiles.get().add(value)) {
            DefinitionResolver.doVisitRncOrRngFile(value, this);
        }
    }

    private static void doVisitRncOrRngFile(PsiFile file, CommonElement.Visitor visitor) {
        DomManager mgr;
        DomFileElement element;
        if (file instanceof RncFile) {
            RncGrammar grammar = ((RncFile)file).getGrammar();
            if (grammar != null) {
                grammar.acceptChildren(visitor);
            }
        } else if (file instanceof XmlFile && (element = (mgr = DomManager.getDomManager((Project)file.getProject())).getFileElement((XmlFile)file, RngGrammar.class)) != null) {
            ((RngGrammar)element.getRootElement()).acceptChildren(visitor);
        }
    }

    @Override
    public void visitDiv(Div div) {
        div.acceptChildren(this);
    }

    @Override
    public void visitDefine(Define def) {
        ((Set)ContainerUtil.getOrCreate(myDefines.get(), (Object)def.getName(), (Factory)this)).add(def);
    }

    @Override
    public void visitPattern(Pattern pattern) {
    }

    @Override
    public void visitGrammar(Grammar pattern) {
    }

    @Override
    public void visitRef(Ref ref) {
    }

    public Set<Define> create() {
        return new THashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedValueProvider.Result<Map<String, Set<Define>>> compute() {
        try {
            this.myScope.acceptChildren(this);
            Object psiElement = this.myScope.getPsiElement();
            if (psiElement == null || !psiElement.isValid()) {
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                return result2;
            }
            PsiFile file = psiElement.getContainingFile();
            if (myVisitedFiles.get() != null) {
                myVisitedFiles.get().add(file);
                CachedValueProvider.Result result3 = CachedValueProvider.Result.create(myDefines.get(), (Object[])myVisitedFiles.get().toArray());
                return result3;
            }
            CachedValueProvider.Result result4 = CachedValueProvider.Result.create(myDefines.get(), (Object[])new Object[]{file});
            return result4;
        }
        finally {
            myVisitedFiles.remove();
            myDefines.remove();
        }
    }

    @Nullable
    public static Set<Define> resolve(Grammar scope, String value) {
        PsiFile file;
        Object element;
        Map<String, Set<Define>> map = DefinitionResolver.getAllVariants(scope);
        if (map == null) {
            return null;
        }
        Set<Define> set = map.get(value);
        if ((set == null || set.size() == 0) && (element = scope.getPsiElement()) != null && (file = element.getContainingFile()) instanceof XmlFile) {
            BackwardDefinitionResolver resolver = new BackwardDefinitionResolver(value);
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file, resolver);
            return resolver.getResult();
        }
        return set;
    }

    @Nullable
    public static Map<String, Set<Define>> getAllVariants(Grammar scope) {
        Object psiElement = scope.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)psiElement.getProject());
        CachedValue data = (CachedValue)psiElement.getUserData(KEY);
        if (data == null || !((DefinitionResolver)data.getValueProvider()).isValid()) {
            DefinitionResolver resolver = new DefinitionResolver(scope);
            data = manager.createCachedValue((CachedValueProvider)resolver, false);
            psiElement.putUserData(KEY, (Object)data);
        }
        return (Map)data.getValue();
    }

    private boolean isValid() {
        Object element = this.myScope.getPsiElement();
        return element != null && element.isValid();
    }

    private static class BackwardDefinitionResolver
    implements PsiElementProcessor<XmlFile> {
        private final String myValue;
        private Define myResult;
        private final Set<PsiFile> myVisitedPsiFiles = new HashSet();

        public BackwardDefinitionResolver(String value) {
            this.myValue = value;
        }

        public boolean execute(@NotNull XmlFile element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/model/resolve/DefinitionResolver$BackwardDefinitionResolver", "execute"));
            }
            Grammar g = GrammarFactory.getGrammar(element);
            if (g != null) {
                g.acceptChildren(new CommonElement.Visitor(){

                    @Override
                    public void visitElement(CommonElement pattern) {
                        if (BackwardDefinitionResolver.this.myResult == null) {
                            super.visitElement(pattern);
                        }
                    }

                    @Override
                    public void visitDefine(Define define) {
                        if (BackwardDefinitionResolver.this.myValue.equals(define.getName())) {
                            BackwardDefinitionResolver.this.myResult = define;
                        }
                    }

                    @Override
                    public void visitInclude(Include include) {
                        PsiFile file = include.getInclude();
                        if (file != null && BackwardDefinitionResolver.this.myVisitedPsiFiles.add(file)) {
                            DefinitionResolver.doVisitRncOrRngFile(file, this);
                        }
                    }
                });
            }
            return this.myResult == null;
        }

        @Nullable
        public Set<Define> getResult() {
            return this.myResult != null ? Collections.singleton(this.myResult) : null;
        }
    }
}

