/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

public class BuiltInWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    @NotNull
    public static List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
        }
        if (currentAuthority != null && !BuiltInWebBrowserUrlProvider.compareAuthority(currentAuthority)) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
            }
            return list;
        }
        String path = WebServerPathToFileManager.getInstance(project).getPath(file);
        if (path == null) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
            }
            return list;
        }
        int effectiveBuiltInServerPort = BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        Url url = Urls.newHttpUrl(currentAuthority == null ? "localhost:" + effectiveBuiltInServerPort : currentAuthority, '/' + project.getName() + '/' + path);
        int defaultPort = BuiltInServerManager.getInstance().getPort();
        if (currentAuthority != null || defaultPort == effectiveBuiltInServerPort) {
            List<Url> list = Collections.singletonList(url);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
            }
            return list;
        }
        List<Url> list = Arrays.asList(url, Urls.newHttpUrl("localhost:" + defaultPort, '/' + project.getName() + '/' + path));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrls"));
        }
        return list;
    }

    public static boolean compareAuthority(@Nullable String currentAuthority) {
        if (StringUtil.isEmpty((String)currentAuthority)) {
            return false;
        }
        int portIndex = currentAuthority.indexOf(58);
        if (portIndex < 0) {
            return false;
        }
        String host = currentAuthority.substring(0, portIndex);
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        int port = StringUtil.parseInt((String)currentAuthority.substring(portIndex + 1), (int)-1);
        return port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() || port == BuiltInServerManager.getInstance().getPort();
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "canHandleElement"));
        }
        if (request.getVirtualFile() instanceof HttpVirtualFile) {
            return true;
        }
        FileViewProvider viewProvider = request.getFile().getViewProvider();
        return viewProvider.isPhysical() && !(request.getVirtualFile() instanceof LightVirtualFile) && this.isMyLanguage(viewProvider.getBaseLanguage());
    }

    protected boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "isMyLanguage"));
        }
        return WebBrowserService.isHtmlOrXmlFile((Language)language);
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws WebBrowserUrlProvider.BrowserException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider", "getUrl"));
        }
        if (file instanceof HttpVirtualFile) {
            return Urls.newFromVirtualFile(file);
        }
        return (Url)ContainerUtil.getFirstItem(BuiltInWebBrowserUrlProvider.getUrls(file, request.getProject(), null));
    }
}

