/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class JsonUtil {
    private static final String[] REPLACEMENT_CHARS = new String[128];

    /*
     * WARNING - void declaration
     */
    public static void escape(@NotNull CharSequence value, @NotNull StringBuilder sb) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/io/JsonUtil", "escape"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/io/JsonUtil", "escape"));
        }
        int length = value.length();
        sb.ensureCapacity(sb.capacity() + length + 2);
        sb.append('\"');
        int last = 0;
        for (int i = 0; i < length; ++i) {
            void var6_6;
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sb.append(value, last, i);
            }
            sb.append((String)var6_6);
            last = i + 1;
        }
        if (last < length) {
            sb.append(value, last, length);
        }
        sb.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    public static void escape(@NotNull CharSequence value, @NotNull ByteBuf buffer) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/io/JsonUtil", "escape"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/JsonUtil", "escape"));
        }
        int length = value.length();
        buffer.ensureWritable(length * 2);
        buffer.writeByte(34);
        int last = 0;
        for (int i = 0; i < length; ++i) {
            void var6_6;
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                ByteBufUtilEx.writeUtf8(buffer, value, last, i);
            }
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)var6_6);
            last = i + 1;
        }
        if (last < length) {
            ByteBufUtilEx.writeUtf8(buffer, value, last, length);
        }
        buffer.writeByte(34);
    }

    @NotNull
    public static <T> List<T> nextList(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/io/JsonUtil", "nextList"));
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/JsonUtil", "nextList"));
            }
            return list;
        }
        SmartList list = new SmartList();
        JsonUtil.readListBody(reader, list);
        reader.endArray();
        SmartList smartList = list;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/JsonUtil", "nextList"));
        }
        return smartList;
    }

    @NotNull
    public static Object[] nextArray(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/io/JsonUtil", "nextArray"));
        }
        List list = JsonUtil.nextList(reader);
        Object[] objectArray = ArrayUtil.toObjectArray(list);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/JsonUtil", "nextArray"));
        }
        return objectArray;
    }

    @NotNull
    public static Map<String, Object> nextObject(@NotNull JsonReaderEx reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/io/JsonUtil", "nextObject"));
        }
        THashMap map = new THashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            map.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        THashMap tHashMap = map;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/JsonUtil", "nextObject"));
        }
        return tHashMap;
    }

    @Nullable
    public static Object nextAny(JsonReaderEx reader) {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextObject(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static <T> void readListBody(JsonReaderEx reader, List<T> list) {
        do {
            list.add(JsonUtil.nextAny(reader));
        } while (reader.hasNext());
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonUtil.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonUtil.REPLACEMENT_CHARS[34] = "\\\"";
        JsonUtil.REPLACEMENT_CHARS[92] = "\\\\";
        JsonUtil.REPLACEMENT_CHARS[9] = "\\t";
        JsonUtil.REPLACEMENT_CHARS[8] = "\\b";
        JsonUtil.REPLACEMENT_CHARS[10] = "\\n";
        JsonUtil.REPLACEMENT_CHARS[13] = "\\r";
        JsonUtil.REPLACEMENT_CHARS[12] = "\\f";
    }
}

