/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.html.CodeFenceGeneratingProvider;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlBlockGeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.ImageGeneratingProvider;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.ListItemGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer._MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001BE\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001B\u0006\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u000f\t-AY!D\u0004\n\u0005%\t\u0001TB\u0005\u0003\u0013\u0005Ar\u0001\u0007\u0004\u001a\u0007!=Q\"\u0001\r\tK\u0011!1\u0002#\u0005\u000e\u0003aI\u0011F\u0003\u0003L\u0011!\rQ\"\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u000bA1!\u000b\u0006\u0005\u0017\"A9!D\u0001\u0019\tE\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"\u0002"}, strings={"Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "()V", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;"}, moduleName="intellij-markdown")
public class CommonMarkFlavourDescriptor
implements MarkdownFlavourDescriptor {
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory = CommonMarkMarkerProcessor.Factory.INSTANCE;
    @NotNull
    private final SequentialParserManager sequentialParserManager = new SequentialParserManager(){

        @NotNull
        public List<SequentialParser> getParserSequence() {
            return CollectionsKt.listOf((Object[])new SequentialParser[]{new AutolinkParser(CollectionsKt.listOf((Object)MarkdownTokenTypes.Companion.getAUTOLINK())), new BacktickParser(), new ImageParser(), new InlineLinkParser(), new ReferenceLinkParser(), new EmphStrongParser()});
        }
    };

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _MarkdownLexer((Reader)null));
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap) {
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        return MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.Companion.getMARKDOWN_FILE(), (Object)new SimpleTagProvider("body")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getHTML_BLOCK(), (Object)new HtmlBlockGeneratingProvider()), TuplesKt.to((Object)MarkdownTokenTypes.Companion.getHTML_TAG(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                visitor.consumeHtml(ASTUtilKt.getTextInNode(node, text));
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getBLOCK_QUOTE(), (Object)new SimpleTagProvider("blockquote")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getORDERED_LIST(), (Object)new SimpleTagProvider("ol"){

            /*
             * WARNING - void declaration
             */
            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Object attribute;
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                Object object = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.Companion.getLIST_ITEM());
                if (object != null && (object = ASTUtilKt.findChildOfType((ASTNode)object, MarkdownTokenTypes.Companion.getLIST_NUMBER())) != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, text)) != null && (object = object.toString()) != null && (object = StringsKt.trim((String)object)) != null) {
                    void $receiver;
                    Object object2 = object;
                    String it = (String)$receiver;
                    String number = StringsKt.trimStart((String)StringsKt.substring((String)it, (int)0, (int)(it.length() - 1)), (char[])new char[]{'0'});
                    if (!number.equals("1")) {
                        attribute.element = "start=" + "\"" + (StringsKt.isEmpty((CharSequence)number) ? "0" : number) + "\"";
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "ol", new CharSequence[]{(String)attribute.element}, false, 8);
                attribute = null;
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getUNORDERED_LIST(), (Object)new SimpleTagProvider("ul")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getLIST_ITEM(), (Object)new ListItemGeneratingProvider()), TuplesKt.to((Object)MarkdownTokenTypes.Companion.getSETEXT_CONTENT(), (Object)new TrimmingInlineHolderProvider()), TuplesKt.to((Object)MarkdownElementTypes.Companion.getSETEXT_1(), (Object)new SimpleTagProvider("h1")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getSETEXT_2(), (Object)new SimpleTagProvider("h2")), TuplesKt.to((Object)MarkdownTokenTypes.Companion.getATX_CONTENT(), (Object)new TrimmingInlineHolderProvider()), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_1(), (Object)new SimpleTagProvider("h1")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_2(), (Object)new SimpleTagProvider("h2")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_3(), (Object)new SimpleTagProvider("h3")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_4(), (Object)new SimpleTagProvider("h4")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_5(), (Object)new SimpleTagProvider("h5")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getATX_6(), (Object)new SimpleTagProvider("h6")), TuplesKt.to((Object)MarkdownElementTypes.Companion.getAUTOLINK(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text);
                String link = EntityConverter.INSTANCE.replaceEntities(linkText.subSequence(1, linkText.length() - 1), true, false);
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "a", new CharSequence[]{"href=" + "\"" + LinkMap.Builder.normalizeDestination(linkText) + "\""}, false, 8);
                visitor.consumeHtml(link);
                visitor.consumeTagClose("a");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getLINK_LABEL(), (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getLINK_TEXT(), (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getLINK_TITLE(), (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getINLINE_LINK(), (Object)new InlineLinkGeneratingProvider()), TuplesKt.to((Object)MarkdownElementTypes.Companion.getFULL_REFERENCE_LINK(), (Object)new ReferenceLinksGeneratingProvider(linkMap)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getSHORT_REFERENCE_LINK(), (Object)new ReferenceLinksGeneratingProvider(linkMap)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getIMAGE(), (Object)new ImageGeneratingProvider(linkMap)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getLINK_DEFINITION(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getCODE_FENCE(), (Object)new CodeFenceGeneratingProvider()), TuplesKt.to((Object)MarkdownElementTypes.Companion.getCODE_BLOCK(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                visitor.consumeHtml("<pre>");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "code", new CharSequence[0], false, 8);
                visitor.consumeHtml(HtmlGenerator.Companion.trimIndents(HtmlGenerator.Companion.leafText(text, node, false), 4));
                visitor.consumeHtml("\n");
                visitor.consumeTagClose("code");
                visitor.consumeHtml("</pre>");
            }
        }), TuplesKt.to((Object)MarkdownTokenTypes.Companion.getHORIZONTAL_RULE(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                visitor.consumeHtml("<hr />");
            }
        }), TuplesKt.to((Object)MarkdownTokenTypes.Companion.getHARD_LINE_BREAK(), (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                visitor.consumeHtml("<br />");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getPARAGRAPH(), (Object)new TrimmingInlineHolderProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8);
            }

            public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                visitor.consumeTagClose("p");
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.Companion.getEMPH(), (Object)new SimpleInlineTagProvider("em", 1, -1)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getSTRONG(), (Object)new SimpleInlineTagProvider("strong", 2, -2)), TuplesKt.to((Object)MarkdownElementTypes.Companion.getCODE_SPAN(), (Object)new GeneratingProvider(){

            /*
             * WARNING - void declaration
             */
            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Iterable iterable = node.getChildren().subList(1, node.getChildren().size() - 1);
                void var6_5 = $receiver2;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (T item : $receiver) {
                    void node2;
                    ASTNode aSTNode = (ASTNode)item;
                    void var14_10 = destination;
                    CharSequence charSequence = HtmlGenerator.Companion.leafText(text, (ASTNode)node2, false);
                    var14_10.add(charSequence);
                }
                String output = StringsKt.trim((String)CollectionsKt.joinToString$default((Iterable)((List)destination), (CharSequence)"", null, null, (int)0, null, null, (int)62));
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "code", new CharSequence[0], false, 8);
                visitor.consumeHtml(output);
                visitor.consumeTagClose("code");
            }
        })});
    }
}

