/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeBlockMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!)\u0002R\u0007\u0005A\u0019!J\u000b\u0005\u0017!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\u000b!\u001dQb\u0001\r\u0005S\u0005AJ!G\u0002\t\u000b5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001G\u0001&\u001d\u0011Y\u0001RB\u0007\u00021\u001dIR\u0001c\u0002\u000e\u0007a!\u0011&\u0001M\u00053\rAy!D\u0001\u0019\u0011\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;"}, moduleName="intellij-markdown")
public final class CodeBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (stateInfo.getNextConstraints().getCharsEaten(pos.getCurrentLine()) > pos.getOffsetInCurrentLine()) {
            return CollectionsKt.emptyList();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int charsToNonWhitespace = ((Number)n).intValue();
        LookaheadText.Position position = pos.nextPosition(charsToNonWhitespace);
        if (position == null) {
            return CollectionsKt.emptyList();
        }
        LookaheadText.Position blockStart = position;
        if (MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(blockStart, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new CodeBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }
}

