/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    public static final GitBranchesCollection EMPTY = new GitBranchesCollection(Collections.<GitLocalBranch>emptyList(), Collections.<GitRemoteBranch>emptyList());
    private final Collection<GitLocalBranch> myLocalBranches;
    private final Collection<GitRemoteBranch> myRemoteBranches;

    public GitBranchesCollection(@NotNull Collection<GitLocalBranch> localBranches, @NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/branch/GitBranchesCollection", "<init>"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranches", "git4idea/branch/GitBranchesCollection", "<init>"));
        }
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Collection<GitLocalBranch> collection = Collections.unmodifiableCollection(this.myLocalBranches);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchesCollection", "getLocalBranches"));
        }
        return collection;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Collection<GitRemoteBranch> collection = Collections.unmodifiableCollection(this.myRemoteBranches);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchesCollection", "getRemoteBranches"));
        }
        return collection;
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findLocalBranch"));
        }
        return GitBranchesCollection.findByName(this.myLocalBranches, name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findBranchByName"));
        }
        GitLocalBranch branch = GitBranchesCollection.findByName(this.myLocalBranches, name);
        return branch != null ? branch : GitBranchesCollection.findByName(this.myRemoteBranches, name);
    }

    @Nullable
    private static <T extends GitBranch> T findByName(Collection<T> branches, final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findByName"));
        }
        return (T)((GitBranch)ContainerUtil.find(branches, (Condition)new Condition<T>(){

            public boolean value(T branch) {
                return name.equals(((GitReference)branch).getName());
            }
        }));
    }
}

