/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;

public class ExtensionPointLocator {
    private final PsiClass myPsiClass;

    public ExtensionPointLocator(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public List<ExtensionPointCandidate> findDirectCandidates() {
        SmartList candidates = new SmartList();
        ExtensionPointLocator.findExtensionPointCandidates(this.myPsiClass, (List<ExtensionPointCandidate>)candidates);
        return candidates;
    }

    public List<ExtensionPointCandidate> findSuperCandidates() {
        SmartList candidates = new SmartList();
        ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(this.myPsiClass, (List<ExtensionPointCandidate>)candidates, new HashSet<PsiClass>());
        return candidates;
    }

    private static void findExtensionPointCandidatesInHierarchy(PsiClass psiClass, List<ExtensionPointCandidate> list, HashSet<PsiClass> processed) {
        for (PsiClass superClass : psiClass.getSupers()) {
            if (!processed.add(superClass) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            ExtensionPointLocator.findExtensionPointCandidates(superClass, list);
            ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(superClass, list, processed);
        }
    }

    private static void findExtensionPointCandidates(PsiClass psiClass, final List<ExtensionPointCandidate> list) {
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return;
        }
        Project project = psiClass.getProject();
        Collection candidates = DomService.getInstance().getDomFileCandidates(IdeaPlugin.class, project, GlobalSearchScope.allScope((Project)project));
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)candidates);
        PsiSearchHelper.SERVICE.getInstance((Project)project).processUsagesInNonJavaFiles(name, new PsiNonJavaFileReferenceProcessor(){

            public boolean process(PsiFile file, int startOffset, int endOffset) {
                PsiElement element = file.findElementAt(startOffset);
                ExtensionPointLocator.processExtensionPointCandidate(element, list);
                return true;
            }
        }, scope);
    }

    private static void processExtensionPointCandidate(PsiElement element, List<ExtensionPointCandidate> list) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return;
        }
        if ("extensionPoint".equals(tag.getName())) {
            String epName = ExtensionPointLocator.getEPName(tag);
            if (epName != null) {
                list.add(new ExtensionPointCandidate(ExtensionPointLocator.createPointer(tag), epName));
            }
        } else if ("with".equals(tag.getName())) {
            XmlTag extensionPointTag = tag.getParentTag();
            if (extensionPointTag == null) {
                return;
            }
            if (!"extensionPoint".equals(extensionPointTag.getName())) {
                return;
            }
            String attrName = tag.getAttributeValue("attribute");
            String tagName = tag.getAttributeValue("tag");
            String epName = ExtensionPointLocator.getEPName(extensionPointTag);
            String beanClassName = extensionPointTag.getAttributeValue("beanClass");
            if (attrName == null && tagName == null || epName == null) {
                return;
            }
            list.add(new ExtensionPointCandidate(ExtensionPointLocator.createPointer(extensionPointTag), epName, attrName, tagName, beanClassName));
        }
    }

    private static SmartPsiElementPointer createPointer(XmlTag extensionPointTag) {
        return SmartPointerManager.getInstance((Project)extensionPointTag.getProject()).createSmartPsiElementPointer((PsiElement)extensionPointTag);
    }

    @Nullable
    private static String getEPName(XmlTag tag) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)tag);
        if (!(domElement instanceof ExtensionPoint)) {
            return null;
        }
        return ((ExtensionPoint)domElement).getEffectiveQualifiedName();
    }
}

