/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableEntry;

abstract class ImmutableMapEntry<K, V>
extends ImmutableEntry<K, V> {
    ImmutableMapEntry(K key, V value2) {
        super(key, value2);
        CollectPreconditions.checkEntryNotNull(key, value2);
    }

    ImmutableMapEntry(ImmutableMapEntry<K, V> contents) {
        super(contents.getKey(), contents.getValue());
    }

    abstract ImmutableMapEntry<K, V> getNextInKeyBucket();

    abstract ImmutableMapEntry<K, V> getNextInValueBucket();

    static final class TerminalEntry<K, V>
    extends ImmutableMapEntry<K, V> {
        TerminalEntry(K key, V value2) {
            super(key, value2);
        }

        @Override
        ImmutableMapEntry<K, V> getNextInKeyBucket() {
            return null;
        }

        @Override
        ImmutableMapEntry<K, V> getNextInValueBucket() {
            return null;
        }
    }
}

