/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import java.lang.reflect.Constructor;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();

    public static void setFactory(Class<? extends Factory> factory) {
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor = factory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    public static Logger getInstance(@NonNls String category) {
        return ourFactory.getLoggerInstance(category);
    }

    @NotNull
    public static Logger getInstance(Class cl) {
        Logger logger = Logger.getInstance("#" + cl.getName());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/Logger", "getInstance"));
        }
        return logger;
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(@NonNls String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message, Object ... details) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/diagnostic/Logger", "debug"));
        }
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(String.valueOf(detail));
            }
            this.debug(sb.toString());
        }
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/Logger", "info"));
        }
        this.info(t.getMessage(), t);
    }

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, @Nullable Throwable var2);

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/Logger", "warn"));
        }
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(@NonNls String var1, @Nullable Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new Throwable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        this.error(message);
    }

    public void error(@NonNls String message, String ... details) {
        this.error(message, new Throwable(), details);
    }

    public void error(@NonNls String message, @Nullable Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/Logger", "error"));
        }
        this.error(t.getMessage(), t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public abstract void error(@NonNls String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value2, @Nullable @NonNls Object message) {
        if (!value2) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable());
        }
        return value2;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value2) {
        return value2 || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        public Logger getLoggerInstance(String category) {
            return new DefaultLogger(category);
        }
    }

    public static interface Factory {
        public Logger getLoggerInstance(String var1);
    }
}

