/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class DelegatePsiTarget
implements PsiTarget {
    private final PsiElement myElement;

    public DelegatePsiTarget(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/DelegatePsiTarget", "<init>"));
        }
        this.myElement = element.getNavigationElement();
    }

    public int getTextOffset() {
        TextRange range;
        if (this instanceof PsiDeclaredTarget && (range = ((PsiDeclaredTarget)((Object)this)).getNameIdentifierRange()) != null) {
            return range.getStartOffset() + this.myElement.getTextRange().getStartOffset();
        }
        return this.myElement.getTextOffset();
    }

    @Override
    public void navigate(boolean requestFocus) {
        int offset = this.getTextOffset();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile(this.myElement);
        if (virtualFile != null && virtualFile.isValid()) {
            PsiNavigationSupport.getInstance().createNavigatable(this.myElement.getProject(), virtualFile, offset).navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this.myElement);
    }

    @Override
    public boolean canNavigateToSource() {
        return PsiNavigationSupport.getInstance().canNavigate(this.myElement);
    }

    @Override
    @NotNull
    public final PsiElement getNavigationElement() {
        PsiElement psiElement2 = this.myElement;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DelegatePsiTarget", "getNavigationElement"));
        }
        return psiElement2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatePsiTarget psiTarget = (DelegatePsiTarget)o;
        return this.myElement.equals(psiTarget.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.getNavigationElement().isValid();
    }
}

