/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final Language myLanguage;

    public FileElementInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this.myVirtualFile = file.getVirtualFile();
        this.myProject = file.getProject();
        this.myLanguage = LanguageUtil.getRootLanguage(file);
    }

    @Override
    public PsiElement restoreElement() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    @Override
    public PsiFile restoreFile() {
        PsiElement element = this.restoreElement();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/FileElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof FileElementInfo) {
            return Comparing.equal(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
        }
        if (other instanceof SelfElementInfo || other instanceof ClsElementInfo) {
            return false;
        }
        return Comparing.equal(this.restoreElement(), other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return new TextRange(0, (int)this.myVirtualFile.getLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/FileElementInfo", "getProject"));
        }
        return project;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        Document currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        DocumentEx committedDoc = currentDoc == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange() : new TextRange(0, committedDoc.getTextLength());
    }
}

