/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraversal {
    private final String debugName;
    @NotNull
    public static final TreeTraversal GUIDED_TRAVERSAL = new TreeTraversal("GUIDED_TRAVERSAL"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            GuidedItImpl<? extends T> guidedItImpl = new GuidedItImpl<T>(roots2, tree);
            if (guidedItImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            return guidedItImpl;
        }
    };
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            PreOrderIt<? extends T> preOrderIt = new PreOrderIt<T>(roots2, tree);
            if (preOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            return preOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            PostOrderIt<? extends T> postOrderIt = new PostOrderIt<T>(roots2, tree);
            if (postOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            return postOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_DFS = new TreeTraversal("LEAVES_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            LeavesDfsIt<? extends T> leavesDfsIt = new LeavesDfsIt<T>(roots2, tree);
            if (leavesDfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            return leavesDfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            PlainBfsIt<? extends T> plainBfsIt = new PlainBfsIt<T>(roots2, tree);
            if (plainBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            return plainBfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            TracingBfsIt<? extends T> tracingBfsIt = new TracingBfsIt<T>(roots2, tree);
            if (tracingBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            return tracingBfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_BFS = new TreeTraversal("LEAVES_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            LeavesBfsIt<? extends T> leavesBfsIt = new LeavesBfsIt<T>(roots2, tree);
            if (leavesBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            return leavesBfsIt;
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/util/containers/TreeTraversal", "<init>"));
        }
        this.debugName = debugName;
    }

    @NotNull
    public <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots2, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                It it2 = TreeTraversal.this.createIterator(roots2, tree);
                if (it2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$1", "iterator"));
                }
                return it2;
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> traversal(@Nullable T root, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable<List<T>> jBIterable = this.traversal((T)ContainerUtil.createMaybeSingletonList(root), tree);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<T, ? extends Iterable<? extends T>> var2);

    public String toString() {
        return this.debugName;
    }

    private static class P<T> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        static final Function TO_NODE = new Function<P<?>, Object>(){

            @Override
            public Object fun(P<?> tp) {
                return tp.node;
            }
        };

        private P() {
        }

        Iterator<? extends T> iterator(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$P", "iterator"));
            }
            if (this.it != null) {
                return this.it;
            }
            this.it = this.iterable(tree).iterator();
            this.empty = this.itle == null || !this.it.hasNext();
            return this.it;
        }

        Iterable<? extends T> iterable(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            Iterable<? extends T> iterable;
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$P", "iterable"));
            }
            if (this.itle != null) {
                iterable = this.itle;
            } else {
                this.itle = tree.fun(this.node);
                iterable = JBIterable.from(this.itle);
            }
            return iterable;
        }

        static <T> P<T> create(T node) {
            P<T> p = new P<T>();
            p.node = node;
            return p;
        }

        static <T> P<T> create(Iterable<? extends T> it2) {
            P<T> p = new P<T>();
            p.itle = it2;
            return p;
        }
    }

    private static final class GuidedItImpl<T>
    extends GuidedIt<T> {
        final ArrayDeque<P<T>> stack;
        final Function<T, ? extends Iterable<? extends T>> tree;
        Consumer<GuidedIt<T>> guide;
        T curResult;

        GuidedItImpl(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$GuidedItImpl", "<init>"));
            }
            this.stack = new ArrayDeque();
            this.tree = tree;
            this.stack.addLast(P.create(roots2));
        }

        @Override
        public GuidedIt<T> setGuide(Consumer<GuidedIt<T>> guide) {
            this.guide = guide;
            return this;
        }

        @Override
        public GuidedIt<T> queueNext(T child) {
            if (child != null) {
                this.stack.addLast(P.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> result(T node) {
            this.curResult = node;
            return this;
        }

        @Override
        public T nextImpl() {
            if (this.guide == null) {
                return (T)this.stop();
            }
            while (!this.stack.isEmpty()) {
                P<T> top = this.stack.getLast();
                Iterator<T> it2 = top.iterator(this.tree);
                boolean hasNext = it2.hasNext();
                this.curResult = null;
                if (top.node != null || hasNext) {
                    this.curChild = hasNext ? it2.next() : null;
                    this.curParent = top.node;
                    this.curChildren = top.itle;
                    this.curNoChildren = top.empty;
                    this.guide.consume(this);
                }
                if (!hasNext) {
                    this.stack.removeLast();
                }
                if (this.curResult == null) continue;
                return this.curResult;
            }
            return (T)this.stop();
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        P<T> top;

        TracingBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$TracingBfsIt", "<init>"));
            }
            this.queue = new ArrayDeque();
            this.paths = ContainerUtil.newTroveMap(ContainerUtil.identityStrategy());
            this.tree = tree;
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                for (T t : this.top.iterable(this.tree)) {
                    if (this.paths.containsKey(t)) continue;
                    this.queue.add(t);
                    this.paths.put(t, this.top.node);
                }
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P.create(this.queue.remove());
            return this.top.node;
        }
    }

    private static final class LeavesBfsIt<T>
    extends It<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;

        LeavesBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesBfsIt", "<init>"));
            }
            this.queue = new ArrayDeque();
            this.tree = tree;
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Iterator<T> it2;
                T result2 = this.queue.remove();
                Iterable<T> children = this.tree.fun(result2);
                Iterator<T> iterator2 = it2 = children == null ? null : children.iterator();
                if (it2 == null || !it2.hasNext()) {
                    return result2;
                }
                while (it2.hasNext()) {
                    this.queue.add(it2.next());
                }
            }
            return (T)this.stop();
        }
    }

    private static final class PlainBfsIt<T>
    extends It<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;
        P<T> top;

        PlainBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PlainBfsIt", "<init>"));
            }
            this.queue = new ArrayDeque();
            this.tree = tree;
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                JBIterable.from(this.top.iterable(this.tree)).addAllTo(this.queue);
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P.create(this.queue.remove());
            return this.top.node;
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        LeavesDfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesDfsIt", "<init>"));
            }
            this.tree = tree;
            this.stack.addLast(P.create(roots2));
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                P top = (P)this.stack.getLast();
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    T child = top.iterator(this.tree).next();
                    this.stack.addLast(P.create(child));
                    continue;
                }
                this.stack.removeLast();
                if (!top.empty) continue;
                return (T)(this.stack.isEmpty() ? this.stop() : top.node);
            }
            return (T)this.stop();
        }
    }

    private static final class PostOrderIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        PostOrderIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PostOrderIt", "<init>"));
            }
            this.tree = tree;
            for (T root : roots2) {
                this.stack.addLast(P.create(root));
            }
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Iterator<T> it2 = ((P)this.stack.getLast()).iterator(this.tree);
                if (it2.hasNext()) {
                    T result2 = it2.next();
                    this.stack.addLast(P.create(result2));
                    continue;
                }
                return ((P)this.stack.removeLast()).node;
            }
            return (T)this.stop();
        }
    }

    private static final class PreOrderIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        PreOrderIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PreOrderIt", "<init>"));
            }
            this.tree = tree;
            this.stack.addLast(P.create(roots2));
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Iterator<T> it2 = ((P)this.stack.getLast()).iterator(this.tree);
                if (it2.hasNext()) {
                    T result2 = it2.next();
                    this.stack.addLast(P.create(result2));
                    return result2;
                }
                this.stack.removeLast();
            }
            return (T)this.stop();
        }
    }

    private static abstract class DfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<P<T>> stack = new ArrayDeque();

        private DfsIt() {
        }
    }

    public static abstract class GuidedIt<T>
    extends It<T> {
        @Nullable
        public T curChild;
        @Nullable
        public T curParent;
        @Nullable
        public Iterable<? extends T> curChildren;
        public boolean curNoChildren;

        public abstract GuidedIt<T> setGuide(Consumer<GuidedIt<T>> var1);

        public abstract GuidedIt<T> queueNext(T var1);

        public abstract GuidedIt<T> result(T var1);
    }

    public static abstract class TracingIt<T>
    extends It<T> {
    }

    public static abstract class It<T>
    extends JBIterator<T> {
    }
}

