/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.graph.GraphGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CachingSemiGraph<Node>
implements GraphGenerator.SemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, Set<Node>> myIn = new LinkedHashMap<Node, Set<Node>>();

    public CachingSemiGraph(GraphGenerator.SemiGraph<Node> original) {
        this.myNodes = new LinkedHashSet<Node>();
        for (Node node1 : original.getNodes()) {
            this.myNodes.add(node1);
        }
        for (Node node : this.myNodes) {
            LinkedHashSet<Node> value2 = new LinkedHashSet<Node>();
            Iterator<Node> itin = original.getIn(node);
            while (itin.hasNext()) {
                value2.add(itin.next());
            }
            this.myIn.put(node, value2);
        }
    }

    public static <T> CachingSemiGraph<T> create(GraphGenerator.SemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myNodes;
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        return this.myIn.get(n).iterator();
    }
}

