/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public class PrintingMessageCollector
implements MessageCollector {
    public static final MessageCollector PLAIN_TEXT_TO_SYSTEM_ERR = new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, false);
    private final boolean verbose;
    private final PrintStream errStream;
    private final MessageRenderer messageRenderer;

    public PrintingMessageCollector(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, boolean verbose2) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector", "<init>"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector", "<init>"));
        }
        this.verbose = verbose2;
        this.errStream = errStream;
        this.messageRenderer = messageRenderer;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector", "report"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector", "report"));
        }
        if (!this.verbose && CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            return;
        }
        this.errStream.println(this.messageRenderer.render(severity, message, location2));
    }
}

