/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.util.JavaClassSupers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.PropertyMetadata;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CliModuleVisibilityManagerImpl;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmCliVirtualFileFinderFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$sourceLinesOfCode$1;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.codegen.extensions.ClassBuilderInterceptorExtension;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.extensions.ExternalDeclarationsProvider;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.parsing.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisCompletedHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.CliDeclarationProviderFactoryService;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.utils.PathUtil;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\t\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!yQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!\u0001\u0007\u0001!mI\u0012\u0001'\u0001\u001e\u0002m\t{\u0002B\u0001\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006%\u0019\u0001bA\u0007\u00021\u000f\t6!\u0001\u0005\u0005K!A\u0019#\u0004\u0002\r\u0002a\u0011\u0012d\u0001E\u0013\u001b\u0005A2#\n\u0006\t(5\t\u0001dD\r\u0007\u00117iA!\u0003\u0002\n\u0003aq\u0001\u0004F\u0013\t\t\u0005AI#D\u0001\u0019+e\u0019\u0001bA\u0007\u00021\u000f)\u0013\u0002B\u0001\t,5\u0011A\u0012\u0001\r\u00133\rA)#D\u0001\u0019-\u0015JA!\u0001E\u0017\u001b\ta\t\u0001\u0007\n\u001a\u0007!\u0015R\"\u0001\r\u0014K\u0019Aq#\u0004\u0003\n\u0005%\t\u0001D\u0004\r\u0015K\u001d!\u0011\u0001c\f\u000e\t%\u0011\u0011\"\u0001M\u00191a)C\u0002B\u0001\t35\t\u0001$F\r\u0004\u0011gi\u0011\u0001\u0007\u000e\u001a\u0007!UR\"\u0001M\u0019S)!1\t\u0003E\u0005\u001b\u0005AR\u0001H\u0012R\u0007\ri!\u0001b\u0003\t\r%RA!\u0011\u0005\t\u00055\t\u0001T\u0002\u000f\"#\u000e\u0019QB\u0001\u0003\b\u0011\u001fI#\u0002B\"\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0011!E\u0011F\u0003\u0003B\u0011!IQ\u0002B\u0005\u0003\u0013\u0005A\"\u0002g\u0005R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A)\"D\u0001\u0019\u0017q\u0019\u0013kA\u0002\u000e\u0005\u0011]\u0001\u0002D\u0015\b\t\u0005C\u0001\u0012D\u0007\u000215\t6!A\u0003\u0001S)!\u0011\t\u0003E\u000e\u001b\u0011I!!C\u0001\u0019\u001daM\u0011kA\u0001\u0006\u0001%jAa\u0011\u0005\t\u001e5\t\u0001d\u0004\u000f$#\u000e1QA\u0001C\u0011\u0011Ei!\u0001b\b\t!\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "applicationEnvironment", "Lcom/intellij/core/JavaCoreApplicationEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/core/JavaCoreApplicationEnvironment;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "application", "Lcom/intellij/mock/MockApplication;", "getApplication", "()Lcom/intellij/mock/MockApplication;", "Lcom/intellij/core/CoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/CoreApplicationEnvironment;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "javaRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JavaRoot;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLinesOfCode", "", "getSourceLinesOfCode", "()I", "sourceLinesOfCode$delegate", "Lkotlin/Lazy;", "contentRootToVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "countLinesOfCode", "", "fillClasspath", "", "findJarRoot", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmClasspathRoot;", "findLocalDirectory", "getSourceFiles", "getSourceRootsCheckingForDuplicates", "", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "Companion"}, moduleName="kotlin-compiler")
public final class KotlinCoreEnvironment {
    private static final Object APPLICATION_LOCK;
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final ArrayList<KtFile> sourceFiles;
    private final ArrayList<JavaRoot> javaRoots;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy<? extends Integer> sourceLinesOfCode$delegate;
    private static final /* synthetic */ PropertyMetadata[] $$delegatedProperties;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.INSTANCE;
        APPLICATION_LOCK = new Object();
        $$delegatedProperties = new PropertyMetadata[]{KotlinCoreEnvironment$sourceLinesOfCode$1.INSTANCE};
    }

    @NotNull
    public final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private final CoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull(coreApplicationEnvironment, "projectEnvironment.getEnvironment()");
        return coreApplicationEnvironment;
    }

    @NotNull
    public final MockApplication getApplication() {
        MockApplication mockApplication = this.getApplicationEnvironment().getApplication();
        Intrinsics.checkExpressionValueIsNotNull(mockApplication, "applicationEnvironment.getApplication()");
        return mockApplication;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.projectEnvironment.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "projectEnvironment.getProject()");
        return project;
    }

    public final int getSourceLinesOfCode() {
        return ((Number)LazyKt.getValue(this.sourceLinesOfCode$delegate, this, (KProperty)$$delegatedProperties[0])).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int countLinesOfCode(@NotNull List<? extends KtFile> sourceFiles) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Iterable $receiver = sourceFiles;
        int sum = 0;
        for (Object element : $receiver) {
            void it;
            KtFile ktFile = (KtFile)element;
            int n = sum;
            String text = it.getText();
            Integer n2 = StringUtil.getLineBreakCount(it.getText()) + (StringUtil.endsWithLineBreak(text) ? 0 : 1);
            sum = n + ((Number)n2).intValue();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillClasspath(CompilerConfiguration configuration) {
        for (ContentRoot root : configuration.getList(CommonConfigurationKeys.CONTENT_ROOTS)) {
            JavaRoot.RootType rootType;
            FqName fqName2;
            Object object;
            VirtualFile virtualFile;
            JvmContentRoot javaRoot;
            ContentRoot contentRoot = root;
            if (!(contentRoot instanceof JvmContentRoot)) {
                contentRoot = null;
            }
            if ((JvmContentRoot)contentRoot == null) {
                continue;
            }
            if (this.contentRootToVirtualFile(javaRoot) == null) {
                continue;
            }
            this.projectEnvironment.addSourcesToClasspath(virtualFile);
            JvmContentRoot jvmContentRoot = javaRoot;
            if (!(jvmContentRoot instanceof JavaSourceRoot)) {
                jvmContentRoot = null;
            }
            if ((object = (JavaSourceRoot)jvmContentRoot) != null && (object = ((JavaSourceRoot)object).getPackagePrefix()) != null) {
                FqName fqName3;
                void $receiver;
                Object object2 = object;
                String it = (String)$receiver;
                if (FqNamesUtilKt.isValidJavaFqName(it)) {
                    fqName3 = new FqName(it);
                } else {
                    this.report(CompilerMessageSeverity.WARNING, "Invalid package prefix name is ignored: " + it);
                    fqName3 = null;
                }
                fqName2 = fqName3;
            } else {
                fqName2 = null;
            }
            FqName prefixPackageFqName = fqName2;
            JvmContentRoot jvmContentRoot2 = javaRoot;
            if (jvmContentRoot2 instanceof JavaSourceRoot) {
                rootType = JavaRoot.RootType.SOURCE;
            } else if (jvmContentRoot2 instanceof JvmClasspathRoot) {
                rootType = JavaRoot.RootType.BINARY;
            } else {
                throw (Throwable)new IllegalStateException();
            }
            JavaRoot.RootType rootType2 = rootType;
            this.javaRoots.add(new JavaRoot(virtualFile, rootType2, prefixPackageFqName));
        }
    }

    @Nullable
    public final VirtualFile contentRootToVirtualFile(@NotNull JvmContentRoot root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        JvmContentRoot jvmContentRoot = root;
        if (jvmContentRoot instanceof JvmClasspathRoot) {
            return ((JvmClasspathRoot)root).getFile().isFile() ? this.findJarRoot((JvmClasspathRoot)root) : this.findLocalDirectory(root);
        }
        if (jvmContentRoot instanceof JavaSourceRoot) {
            return ((JavaSourceRoot)root).getFile().isDirectory() ? this.findLocalDirectory(root) : (VirtualFile)null;
        }
        throw (Throwable)new IllegalStateException("Unexpected root: " + root);
    }

    private final VirtualFile findLocalDirectory(JvmContentRoot root) {
        File path = root.getFile();
        VirtualFile localFile = this.getApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
        if (localFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
            return null;
        }
        return localFile;
    }

    private final VirtualFile findJarRoot(JvmClasspathRoot root) {
        File path = root.getFile();
        VirtualFile jarFile = this.getApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (jarFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
            return null;
        }
        return jarFile;
    }

    private final Collection<String> getSourceRootsCheckingForDuplicates() {
        LinkedHashSet<String> uniqueSourceRoots = Sets.newLinkedHashSet();
        Iterable $receiver = ContentRootsKt.getKotlinSourceRoots(this.configuration);
        for (Object element : $receiver) {
            String path = (String)element;
            if (uniqueSourceRoots.add(path)) continue;
            this.report(CompilerMessageSeverity.WARNING, "Duplicate source root: " + path);
        }
        Collection collection = uniqueSourceRoots;
        Intrinsics.checkExpressionValueIsNotNull(collection, "uniqueSourceRoots");
        return collection;
    }

    @NotNull
    public final List<KtFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private final void report(CompilerMessageSeverity severity, String message) {
        MessageCollector messageCollector = this.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            throw (Throwable)new CompileEnvironmentException(message);
        }
        MessageCollector messageCollector2 = messageCollector;
        messageCollector2.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCoreEnvironment(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment, CompilerConfiguration configuration) {
        CompilerConfiguration compilerConfiguration;
        void $receiver;
        this.projectEnvironment = new KotlinCoreProjectEnvironment(parentDisposable, applicationEnvironment){

            protected void preregisterServices() {
                ExtensionsArea extensionsArea = Extensions.getArea(this.getProject());
                Intrinsics.checkExpressionValueIsNotNull(extensionsArea, "Extensions.getArea(getProject())");
                org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$registerProjectExtensionPoints(KotlinCoreEnvironment.Companion, extensionsArea);
            }
        };
        this.sourceFiles = new ArrayList();
        this.javaRoots = new ArrayList();
        CompilerConfiguration compilerConfiguration2 = configuration.copy();
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        CompilerConfiguration it = (CompilerConfiguration)$receiver;
        it.setReadOnly(true);
        CompilerConfiguration compilerConfiguration3 = compilerConfiguration = it;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration3, "configuration.copy().let\u2026ly(true)\n        it\n    }");
        kotlinCoreEnvironment.configuration = compilerConfiguration3;
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(DeclarationProviderFactoryService.class, new CliDeclarationProviderFactoryService((Collection<? extends KtFile>)this.sourceFiles));
        project.registerService(ModuleVisibilityManager.class, new CliModuleVisibilityManagerImpl());
        KotlinCoreEnvironment.Companion.registerProjectServicesForCLI(this.projectEnvironment);
        Companion.registerProjectServices(this.projectEnvironment);
        this.fillClasspath(configuration);
        CoreJavaFileManager fileManager = ServiceManager.getService(project, CoreJavaFileManager.class);
        JvmDependenciesIndex index2 = new JvmDependenciesIndex((List<? extends JavaRoot>)this.javaRoots);
        CoreJavaFileManager coreJavaFileManager = fileManager;
        if (coreJavaFileManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl");
        }
        ((KotlinCliJavaFileManagerImpl)coreJavaFileManager).initIndex(index2);
        this.sourceFiles.addAll((Collection<KtFile>)CompileEnvironmentUtil.getKtFiles(project, this.getSourceRootsCheckingForDuplicates(), new Function1<String, Unit>(){

            @Override
            public final void invoke(String message) {
                String string = message;
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                this.report(CompilerMessageSeverity.ERROR, string);
            }
        }));
        CollectionsKt.sortedWith((Iterable)this.sourceFiles, (Comparator)new Comparator<KtFile>(){

            @Override
            public int compare(@NotNull KtFile o1, @NotNull KtFile o2) {
                Intrinsics.checkParameterIsNotNull(o1, "o1");
                Intrinsics.checkParameterIsNotNull(o2, "o2");
                String string = o1.getVirtualFile().getPath();
                String string2 = o2.getVirtualFile().getPath();
                Intrinsics.checkExpressionValueIsNotNull(string2, "o2.getVirtualFile().getPath()");
                return StringsKt.compareTo(string, string2, true);
            }
        });
        KotlinScriptDefinitionProvider.getInstance(project).addScriptDefinitions(configuration.getList(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY));
        project.registerService(JvmVirtualFileFinderFactory.class, new JvmCliVirtualFileFinderFactory(index2));
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull(project2, "project");
        ExternalDeclarationsProvider.Companion.registerExtensionPoint(project2);
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull(project3, "project");
        ExpressionCodegenExtension.Companion.registerExtensionPoint(project3);
        Project project4 = project;
        Intrinsics.checkExpressionValueIsNotNull(project4, "project");
        ClassBuilderInterceptorExtension.Companion.registerExtensionPoint(project4);
        Project project5 = project;
        Intrinsics.checkExpressionValueIsNotNull(project5, "project");
        AnalysisCompletedHandlerExtension.Companion.registerExtensionPoint(project5);
        Project project6 = project;
        Intrinsics.checkExpressionValueIsNotNull(project6, "project");
        StorageComponentContainerContributor.Companion.registerExtensionPoint(project6);
        for (ComponentRegistrar registrar : configuration.getList(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS())) {
            MockProject mockProject = project;
            Intrinsics.checkExpressionValueIsNotNull(mockProject, "project");
            registrar.registerProjectComponents(mockProject, configuration);
        }
        this.sourceLinesOfCode$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ KotlinCoreEnvironment this$0;

            public final int invoke() {
                return this.this$0.countLinesOfCode((List<? extends KtFile>)KotlinCoreEnvironment.access$getSourceFiles$p(this.this$0));
            }
            {
                this.this$0 = kotlinCoreEnvironment;
                super(0);
            }
        });
    }

    public /* synthetic */ KotlinCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(parentDisposable, applicationEnvironment, configuration);
    }

    @NotNull
    public static final /* synthetic */ ArrayList<KtFile> access$getSourceFiles$p(KotlinCoreEnvironment $this) {
        return $this.sourceFiles;
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<? extends String> configFilePaths) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
        return Companion.createForProduction(parentDisposable, configuration, configFilePaths);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<? extends String> extensionConfigs) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
        return Companion.createForTests(parentDisposable, configuration, extensionConfigs);
    }

    @JvmStatic
    public static final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
        Companion.registerApplicationServices(applicationEnvironment);
    }

    @JvmStatic
    public static final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
        Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
        Companion.registerProjectServices(projectEnvironment2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Y\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001\u0002B\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\tA\u0011B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)3\u0003B\u0001\t\u00145\t\u0001\u0004B\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0007!YQ\"\u0001M\f3\u0019AA\"\u0004\u0003\n\u0005%\t\u0001$\u0004M\rKM!9\u0001c\u0007\u000e\u0003aq\u0011d\u0001\u0005\u000b\u001b\u0005A*\"G\u0002\t\u00175\t\u0001tC\r\u0007\u00111iA!\u0003\u0002\n\u0003ai\u0001\u0014D\u0013\u0014\t\u000fAi\"D\u0001\u0019\u001de\u0019\u0001BC\u0007\u00021+I2\u0001C\u0006\u000e\u0003a]\u0011D\u0002\u0005\u0010\u001b\u0011I!!C\u0001\u0019\u001baeQe\u0001E\u0010\u001b\u0005A\u0002#J\b\u0005\u0003!\u0005R\"\u0001\r\u00053\rA1\"D\u0001\u0019\u0018e1\u0001\u0002D\u0007\u0005\u0013\tI\u0011\u0001G\u0007\u0019\u001a\u0015\"A!\u0001\u0005\u0012\u001b\u0005A\u0002#\n\u0007\u0005\u0003!\rR\"\u0001\r\u00113\rA1\"D\u0001\u0019\u0018e\u0019\u0001BE\u0007\u000215)\u0003\u0002b\u0002\t&5\t\u0001\u0004E\r\u0004\u0011Mi\u0011\u0001\u0007\u0003&\u0011\u0011\t\u0001rE\u0007\u00021AI2\u0001C\n\u000e\u0003a!Q\u0005\u0003\u0003\u0002\u0011Qi\u0011\u0001\u0007\t\u001a\u0007!%R\"\u0001\r\u0016K!!9\u0001c\u000b\u000e\u0003a\u0001\u0012d\u0001\u0005\u0017\u001b\u0005Aj#\n\u0005\u0005\u0003!9R\"\u0001\r\u00113\rAa#D\u0001\u0019.%ZA!\u0011\u0005\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!K\b\u0005\u0003rA9!\u0004\u0002\r\u0002a!\u0011k\u0001\u0005\u0006\u00031\u0005QB\u0001C\u0005\u0011\u0015\t\"\u0001b\u0003\t\r%rA!\u0011\u000f\t\u000e5\t\u0001dB)\u0004\u0011\u0015\tA\u0012A\u0007\u0003\t\u001fA\u0001\"\u0005\u0002\u0005\u0012!I\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment$Companion;", "", "()V", "APPLICATION_LOCK", "Ljava/lang/Object;", "getAPPLICATION_LOCK", "()Ljava/lang/Object;", "ourApplicationEnvironment", "Lcom/intellij/core/JavaCoreApplicationEnvironment;", "getOurApplicationEnvironment", "()Lcom/intellij/core/JavaCoreApplicationEnvironment;", "setOurApplicationEnvironment", "(Lcom/intellij/core/JavaCoreApplicationEnvironment;)V", "ourProjectCount", "", "getOurProjectCount", "()I", "setOurProjectCount", "(I)V", "createApplicationEnvironment", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configFilePaths", "", "", "createForProduction", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "createForTests", "extensionConfigs", "disposeApplicationEnvironment", "", "getOrCreateApplicationEnvironmentForProduction", "registerAppExtensionPoints", "registerApplicationExtensionPointsAndExtensionsFrom", "configFilePath", "registerApplicationServices", "applicationEnvironment", "registerApplicationServicesForCLI", "registerProjectExtensionPoints", "area", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "registerProjectServices", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "registerProjectServicesForCLI"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Object getAPPLICATION_LOCK() {
            return APPLICATION_LOCK;
        }

        private final JavaCoreApplicationEnvironment getOurApplicationEnvironment() {
            return ourApplicationEnvironment;
        }

        private final void setOurApplicationEnvironment(JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            ourApplicationEnvironment = javaCoreApplicationEnvironment;
        }

        private final int getOurProjectCount() {
            return ourProjectCount;
        }

        private final void setOurProjectCount(int n) {
            ourProjectCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<? extends String> configFilePaths) {
            void lock;
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
            JavaCoreApplicationEnvironment appEnv = this.getOrCreateApplicationEnvironmentForProduction(configuration, configFilePaths);
            if (System.getProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY()) == null) {
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object lock = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (lock) {
                            Companion companion = KotlinCoreEnvironment.Companion;
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurProjectCount$p(companion, org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) + -1);
                            if (org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) <= 0) {
                                KotlinCoreEnvironment.Companion.disposeApplicationEnvironment();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
            }
            KotlinCoreEnvironment environment2 = new KotlinCoreEnvironment(parentDisposable, appEnv, configuration, null);
            Object object = this.getAPPLICATION_LOCK();
            synchronized (lock) {
                Companion companion = Companion;
                int n = companion.getOurProjectCount();
                companion.setOurProjectCount(n + 1);
                int n2 = n;
            }
            return environment2;
        }

        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<? extends String> extensionConfigs) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
            return new KotlinCoreEnvironment(parentDisposable, this.createApplicationEnvironment(parentDisposable, configuration, extensionConfigs), configuration, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction(CompilerConfiguration configuration, List<? extends String> configFilePaths) {
            Object lock = this.getAPPLICATION_LOCK();
            synchronized (lock) {
                Disposable parentDisposable;
                block6: {
                    if (Companion.getOurApplicationEnvironment() == null) break block6;
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                    if (javaCoreApplicationEnvironment == null) {
                        Intrinsics.throwNpe();
                    }
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment2 = javaCoreApplicationEnvironment;
                    return javaCoreApplicationEnvironment2;
                }
                Disposable disposable = parentDisposable = Disposer.newDisposable();
                Intrinsics.checkExpressionValueIsNotNull(disposable, "parentDisposable");
                Companion.setOurApplicationEnvironment(Companion.createApplicationEnvironment(disposable, configuration, configFilePaths));
                Companion.setOurProjectCount(0);
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object lock = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (lock) {
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurApplicationEnvironment$p(KotlinCoreEnvironment.Companion, null);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    Intrinsics.throwNpe();
                }
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment3 = javaCoreApplicationEnvironment;
                return javaCoreApplicationEnvironment3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void disposeApplicationEnvironment() {
            Object lock = this.getAPPLICATION_LOCK();
            synchronized (lock) {
                if (Companion.getOurApplicationEnvironment() == null) {
                    return;
                }
                JavaCoreApplicationEnvironment environment2 = Companion.getOurApplicationEnvironment();
                Companion.setOurApplicationEnvironment(null);
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = environment2;
                if (javaCoreApplicationEnvironment == null) {
                    Intrinsics.throwNpe();
                }
                Disposer.dispose(javaCoreApplicationEnvironment.getParentDisposable());
                Unit unit = Unit.INSTANCE;
            }
        }

        private final JavaCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable, CompilerConfiguration configuration, List<? extends String> configFilePaths) {
            Extensions.cleanRootArea(parentDisposable);
            this.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            for (String string : configFilePaths) {
                this.registerApplicationExtensionPointsAndExtensionsFrom(configuration, string);
            }
            this.registerApplicationServicesForCLI(applicationEnvironment);
            this.registerApplicationServices(applicationEnvironment);
            return applicationEnvironment;
        }

        private final void registerAppExtensionPoints() {
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), MetaDataContributor.EP_NAME, MetaDataContributor.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContainerProvider.EP_NAME, ContainerProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
        }

        private final void registerApplicationExtensionPointsAndExtensionsFrom(CompilerConfiguration configuration, String configFilePath) {
            CompilerJarLocator locator = configuration.get(JVMConfigurationKeys.COMPILER_JAR_LOCATOR);
            File pluginRoot = locator == null ? PathUtil.getPathUtilJar() : locator.getCompilerJar();
            Application app = ApplicationManager.getApplication();
            File parentFile = pluginRoot.getParentFile();
            if (pluginRoot.isDirectory() && app != null && app.isUnitTestMode() && StringsKt.endsWith$default(FileUtil.toCanonicalPath(parentFile.getPath()), "out/production", false, 2)) {
                File srcDir = parentFile.getParentFile().getParentFile();
                pluginRoot = new File(srcDir, "idea/src");
            }
            CoreApplicationEnvironment.registerExtensionPointAndExtensions(pluginRoot, configFilePath, Extensions.getRootArea());
        }

        private final void registerApplicationServicesForCLI(JavaCoreApplicationEnvironment applicationEnvironment) {
            applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
            applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        }

        @JvmStatic
        public final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
            Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
            JavaCoreApplicationEnvironment $receiver = applicationEnvironment;
            $receiver.registerFileType(KotlinFileType.INSTANCE, "kt");
            $receiver.registerFileType(KotlinFileType.INSTANCE, "kts");
            $receiver.registerParserDefinition(new KotlinParserDefinition());
            $receiver.getApplication().registerService(KotlinBinaryClassCache.class, new KotlinBinaryClassCache());
            $receiver.getApplication().registerService(JavaClassSupers.class, JavaClassSupersImpl.class);
        }

        private final void registerProjectExtensionPoints(ExtensionsArea area) {
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiElementFinder.EP_NAME, PsiElementFinder.class);
        }

        @JvmStatic
        public final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
            Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
            MockProject receiver = projectEnvironment2.getProject();
            MockProject $receiver = receiver;
            $receiver.registerService(KotlinScriptDefinitionProvider.class, new KotlinScriptDefinitionProvider());
            $receiver.registerService(KotlinJavaPsiFacade.class, new KotlinJavaPsiFacade($receiver));
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            $receiver.registerService(KtLightClassForFacade.FacadeStubCache.class, new KtLightClassForFacade.FacadeStubCache(project));
        }

        private final void registerProjectServicesForCLI(JavaCoreProjectEnvironment projectEnvironment2) {
            MockProject receiver = projectEnvironment2.getProject();
            MockProject $receiver = receiver;
            JavaFileManager javaFileManager = ServiceManager.getService($receiver, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.core.CoreJavaFileManager");
            }
            $receiver.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)javaFileManager);
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport(project);
            $receiver.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CodeAnalyzerInitializer.class, cliLightClassGenerationSupport);
            ExtensionsArea area = Extensions.getArea($receiver);
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder($receiver, cliLightClassGenerationSupport));
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new PsiElementFinderImpl($receiver, ServiceManager.getService($receiver, JavaFileManager.class)));
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }

        @NotNull
        public static final /* synthetic */ Object access$getAPPLICATION_LOCK$p(Companion $this) {
            return $this.getAPPLICATION_LOCK();
        }

        public static final /* synthetic */ void access$registerProjectExtensionPoints(Companion $this, @NotNull ExtensionsArea area) {
            $this.registerProjectExtensionPoints(area);
        }
    }
}

