/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.inline.InlineUtilKt$WhenMappings;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0005\u0012\u000b\u0005Aq!\u0002\u0001\u0006\u0003!IQ!\u0001\u0003\u0002\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"AG\f\u0011\u0001iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000biy\u0003B\u0001\t\u00015!\u0011BA\u0005\u00021\u0005A\n!\u0007\u0004\t\u00075!\u0011BA\u0005\u00021\u0011A:!G\u0002\t\n5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004U\u0007\u000bi\u0019\u0002B\u0001\t\u000e5\t\u0001dB\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000b\u0001"}, strings={"inlineFunctionsJvmNames", "", "", "bytes", "", "InlineUtilKt", "functions", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "protoTypeTable", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeTable;", "readKotlinHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;"}, moduleName="kotlin-compiler")
public final class InlineUtilKt {
    @NotNull
    public static final Set<String> inlineFunctionsJvmNames(@NotNull byte[] bytes) {
        Set<String> set;
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        KotlinClassHeader header = InlineUtilKt.readKotlinHeader(bytes);
        String[] annotationData = header.getAnnotationData();
        String[] strings = header.getStrings();
        if (annotationData == null || strings == null) {
            return SetsKt.emptySet();
        }
        switch (InlineUtilKt$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(annotationData)");
                ClassData classData = JvmProtoBufUtil.readClassDataFrom(byArray, strings);
                List<ProtoBuf.Function> list = classData.getClassProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list, "classData.classProto.functionList");
                NameResolver nameResolver = classData.getNameResolver();
                ProtoBuf.TypeTable typeTable = classData.getClassProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull(typeTable, "classData.classProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list, nameResolver, typeTable);
                break;
            }
            case 2: 
            case 3: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(annotationData)");
                PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
                List<ProtoBuf.Function> list = packageData.getPackageProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list, "packageData.packageProto.functionList");
                NameResolver nameResolver = packageData.getNameResolver();
                ProtoBuf.TypeTable typeTable = packageData.getPackageProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull(typeTable, "packageData.packageProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list, nameResolver, typeTable);
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> inlineFunctionsJvmNames(List<? extends ProtoBuf.Function> functions2, NameResolver nameResolver, ProtoBuf.TypeTable protoTypeTable) {
        void destination;
        void $receiver;
        Iterable destination2;
        Iterable $receiver2;
        void $receiver3;
        TypeTable typeTable = new TypeTable(protoTypeTable);
        Iterable iterable = functions2;
        void var6_5 = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            ProtoBuf.Function it = (ProtoBuf.Function)element;
            if (!Flags.IS_INLINE.get(it.getFlags()).booleanValue()) continue;
            destination2.add(element);
        }
        List inlineFunctions = (List)destination2;
        $receiver2 = inlineFunctions;
        destination2 = $receiver2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            ProtoBuf.Function $i$a$1 = (ProtoBuf.Function)item;
            void var15_12 = destination;
            String string = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)it, nameResolver, typeTable);
            var15_12.add(string);
        }
        List jvmNames = (List)destination;
        return CollectionsKt.toSet(CollectionsKt.filterNotNull(jvmNames));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinClassHeader readKotlinHeader(byte[] bytes) {
        void header;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FileBasedKotlinClass.create(bytes, new Function3((Ref.ObjectRef)header){
            final /* synthetic */ Ref.ObjectRef $header;

            @Nullable
            public final Void invoke(ClassId className, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
                this.$header.element = classHeader;
                return null;
            }
            {
                this.$header = objectRef;
                super(3);
            }
        });
        if ((KotlinClassHeader)header.element == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Could not read kotlin header from byte array"));
        }
        KotlinClassHeader kotlinClassHeader = (KotlinClassHeader)header.element;
        if (kotlinClassHeader == null) {
            Intrinsics.throwNpe();
        }
        return kotlinClassHeader;
    }
}

