/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.preprocessor.Conditional;
import org.jetbrains.kotlin.preprocessor.ConditionalKt;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.Modification;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\n\u0006\u0003!\u0005R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0014%1\u0001\"A\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004E\u001b\u0011\u0001#\u0002&\u0011\u0011Y\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a=\u0011f\u0005\u0003D\u0011!\u0019QBC\u0005\u0003\u0013\u0005A\"!C\u0003\n\t%\u0011\u0011\"\u0001M\u00051\u0011A:!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\f\u0001"}, strings={"Lorg/jetbrains/kotlin/preprocessor/CollectModificationsVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "evaluators", "", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "(Ljava/util/List;)V", "elementModifications", "", "", "Lorg/jetbrains/kotlin/preprocessor/Modification;", "getElementModifications", "()Ljava/util/Map;", "visitDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;"}, moduleName="kotlin-compiler")
public final class CollectModificationsVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Map<Evaluator, ? extends List<Modification>> elementModifications;

    @NotNull
    public final Map<Evaluator, List<Modification>> getElementModifications() {
        return this.elementModifications;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Object object;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        super.visitDeclaration(declaration);
        List<Conditional> annotations2 = ConditionalKt.parseConditionalAnnotations(declaration);
        KtDeclaration ktDeclaration = declaration;
        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
            ktDeclaration = null;
        }
        Comparable name = (object = (KtNamedDeclaration)ktDeclaration) != null && (object = object.getNameAsSafeName()) != null ? (Comparable)object : (Comparable)((Object)declaration.getName());
        ArrayList<Pair> declResults = CollectionsKt.arrayListOf(new Pair[0]);
        Iterator<Map.Entry<Evaluator, ? extends List<Modification>>> iterator2 = MapsKt.iterator(this.elementModifications);
        while (iterator2.hasNext()) {
            void destination;
            void $receiver;
            void $receiver2;
            void $receiver3;
            void $receiver4;
            Map.Entry<Evaluator, ? extends List<Modification>> entry;
            Map.Entry<Evaluator, ? extends List<Modification>> entry2 = entry = iterator2.next();
            Evaluator evaluator = (Evaluator)$receiver4.getKey();
            Map.Entry<Evaluator, ? extends List<Modification>> $i$f$component1 = entry;
            List modifications = (List)$receiver3.getValue();
            boolean conditionalResult = (Boolean)evaluator.invoke(annotations2);
            declResults.add(TuplesKt.to(evaluator, conditionalResult));
            if (!conditionalResult) {
                TextRange textRange = declaration.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull(textRange, "declaration.textRange");
                modifications.add(new Modification(textRange, (Function1<? super String, ? extends String>)new Function1<String, String>(evaluator){
                    final /* synthetic */ Evaluator $evaluator;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(@NotNull String rangeText) {
                        void var2_2;
                        void times;
                        Intrinsics.checkParameterIsNotNull(rangeText, "rangeText");
                        StringBuilder $receiver = new StringBuilder();
                        StringBuilder $receiver2 = $receiver;
                        $receiver2.append("/* Not available on " + this.$evaluator + " */");
                        int n = StringUtil.getLineBreakCount(rangeText);
                        boolean bl = false;
                        void var6_6 = times - true;
                        if (bl <= var6_6) {
                            void index2;
                            do {
                                void it = ++index2;
                                $receiver2.append("\n");
                            } while (index2 != var6_6);
                        }
                        String string = ((StringBuilder)var2_2).toString();
                        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026             }.toString()");
                        return string;
                    }
                    {
                        this.$evaluator = evaluator;
                        super(1);
                    }
                }));
                continue;
            }
            Iterable iterable = annotations2;
            void var12_13 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                if (!(element instanceof Conditional.TargetName)) continue;
                destination.add(element);
            }
            Conditional.TargetName targetName = (Conditional.TargetName)CollectionsKt.singleOrNull((List)destination);
            if (targetName == null) continue;
            KtDeclaration ktDeclaration2 = declaration;
            if (ktDeclaration2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            }
            Name name2 = ((KtNamedDeclaration)ktDeclaration2).getNameAsName();
            if (name2 == null) {
                Intrinsics.throwNpe();
            }
            String placeholderName = name2.asString();
            String realName = targetName.getName();
            TextRange textRange = ((KtNamedDeclaration)declaration).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull(textRange, "declaration.textRange");
            modifications.add(new Modification(textRange, (Function1<? super String, ? extends String>)new Function1<String, String>(placeholderName, realName){
                final /* synthetic */ String $placeholderName;
                final /* synthetic */ String $realName;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    String string = this.$placeholderName;
                    Intrinsics.checkExpressionValueIsNotNull(string, "placeholderName");
                    return StringsKt.replace$default(it, string, this.$realName, false, 4);
                }
                {
                    this.$placeholderName = string;
                    this.$realName = string2;
                    super(1);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    public CollectModificationsVisitor(@NotNull List<? extends Evaluator> evaluators) {
        LinkedHashMap<void, ArrayList<Modification>> linkedHashMap;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(evaluators, "evaluators");
        Iterable iterable = evaluators;
        CollectModificationsVisitor collectModificationsVisitor = this;
        float capacity = (float)CollectionsKt.collectionSizeOrDefault($receiver, 10) / 0.75f + 1.0f;
        LinkedHashMap<void, ArrayList<Modification>> result2 = new LinkedHashMap<void, ArrayList<Modification>>(Math.max((int)capacity, 16));
        for (Object element : $receiver) {
            Evaluator it;
            Evaluator evaluator = (Evaluator)element;
            linkedHashMap = result2;
            void var12_10 = it;
            it = (Evaluator)element;
            ArrayList<Modification> arrayList = CollectionsKt.arrayListOf(new Modification[0]);
            linkedHashMap.put(var12_10, arrayList);
        }
        collectModificationsVisitor.elementModifications = linkedHashMap = (LinkedHashMap<void, ArrayList<Modification>>)result2;
    }
}

