/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u00171\u0001\u00013D\r\u00021\u0003i\n1DQ\u0004\t\t\t6!\u0001\u0005\u0002K!!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!\n\u0005\u0005\u0018!\u001dQ\"\u0001\r\u00033\rAA!D\u0001\u0019\n\u0015bAa\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001g\u0004&\u0019\u0011Y\u0001\u0002C\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003aE\u0011d\u0001\u0005\b\u001b\u0005Az!\n\u0007\u0005\u0017!IQ\"\u0001M\u00063\rAa!D\u0001\u0019\u0005e\u0019\u0001bB\u0007\u00021\u001f)C\u0002B\u0006\t\u00145\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001\u0007\u0006\u001a\u0007!9Q\"\u0001M\bK1!1\u0002#\u0006\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005A2\"G\u0002\t\u000f5\t\u0001tB\u0013\r\t-A9\"D\u0001\u0019\fe\u0019\u0001BB\u0007\u000211I2\u0001C\u0004\u000e\u0003a=Q\u0005\u0004C\f\u00113i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001\r\u00033\rAA!D\u0001\u0019\u001b\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "", "()V", "createFileStub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "deserializeFileStub", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "indexAnnotation", "", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "indexClass", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "indexFile", "indexFunction", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;", "indexObject", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "indexProperty", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPropertyStub;", "serializeFileStub", "Lcom/intellij/psi/stubs/StubOutputStream;", "Companion"}, moduleName="kotlin-compiler")
public class StubIndexService {
    private static final StubIndexService NO_INDEX;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.psi.stubs.elements.StubIndexService$Companion.INSTANCE;
        NO_INDEX = new StubIndexService();
    }

    public void indexFile(@NotNull KotlinFileStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexClass(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexFunction(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexObject(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexProperty(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String string = file.getPackageFqNameByTree().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.packageFqNameByTree.asString()");
        return new KotlinFileStubImpl(file, string, file.isScriptByTree());
    }

    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        dataStream.writeName(stub.getPackageFqName().asString());
        dataStream.writeBoolean(stub.isScript());
    }

    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        KtFile ktFile = null;
        StringRef stringRef = packageFqNameAsString;
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(stringRef, "packageFqNameAsString!!");
        return new KotlinFileStubImpl(ktFile, stringRef, isScript);
    }

    protected StubIndexService() {
    }

    @JvmStatic
    @NotNull
    public static final StubIndexService getInstance() {
        return Companion.getInstance();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u0003\u0005\b!\u001dQ\"\u0001\r\u0003S-!\u0011\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0006!\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService$Companion;", "", "()V", "NO_INDEX", "Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "getNO_INDEX", "()Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "getInstance"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final StubIndexService getInstance() {
            StubIndexService stubIndexService = ServiceManager.getService(StubIndexService.class);
            if (stubIndexService == null) {
                stubIndexService = this.getNO_INDEX();
            }
            return stubIndexService;
        }

        private final StubIndexService getNO_INDEX() {
            return NO_INDEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

