/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\n\u000b\u0005\u0017!!Q\"\u0001M\u0005#\u0011!\u0001\u0001C\u0003\u0016\u0003a-\u0011D\u0002\u0005\u0007\u001b\u0011I!!C\u0001%\u000ba5\u0011d\u0001\u0005\b\u001b\u0005Az!\n\b\u0005\u0003!AQ\"\u0001M\u00053\rAq!D\u0001\u0019\u0010e)\u0001BB\u0007\u0004\u0013\u0005!\u0019\u0001'\u0004*\u0014\u0011\t\u0005\u0002#\u0002\u000e\ba\u0019\u0011kA\u0001\u0005\bE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;)V", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "reportError"}, moduleName="kotlin-compiler")
public final class ConstructorHeaderCallChecker
implements CallChecker {
    private final ClassDescriptor containingClass;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        KtElement callElement;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (resolvedCall.getStatus().isSuccess()) {
            BindingContext bindingContext2 = context.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "context.trace.getBindingContext()");
            if (ResolvedCallUtilKt.hasImplicitThisOrSuperDispatchReceiver(resolvedCall, bindingContext2) && Intrinsics.areEqual(this.containingClass, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(resolvedCall.getResultingDescriptor()))) {
                this.reportError(context, resolvedCall);
                return;
            }
        }
        if (!((callElement = resolvedCall.getCall().getCallElement()) instanceof KtInstanceExpressionWithLabel)) return;
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference());
        if (!Intrinsics.areEqual(this.containingClass, descriptor2)) return;
        this.reportError(context, resolvedCall);
    }

    private final void reportError(BasicCallResolutionContext context, ResolvedCall<?> resolvedCall) {
        context.trace.report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(context.call.getCalleeExpression(), (DeclarationDescriptor)resolvedCall.getResultingDescriptor()));
    }

    public ConstructorHeaderCallChecker(@NotNull ConstructorDescriptor constructor) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        this.containingClass = constructor.getContainingDeclaration();
    }
}

