/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011C)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0010\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tAaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K=!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0011D\u0002E\u0003\u001b\u0011I!!C\u0001\u0019\ba\u0019\u0011d\u0001\u0005\u0005\u001b\u0005A:!J\u0005\u0005\b!%QB\u0001G\u00011\u0015I2\u0001\u0003\u0003\u000e\u0003a\u001dQ%\u0003\u0003\u0002\u0011\u0017i!\u0001$\u0001\u0019\be\u0019\u0001BB\u0007\u00021\u000f)\u0013\u0002b\u0002\t\u000e5\u0011A\u0012\u0001\r\b3\rAa!D\u0001\u0019\b\u0015ZAq\u0001E\b\u001b\u0011I!!C\u0001\u0019\baA\u0011d\u0001\u0005\u0005\u001b\u0005A:!J\u0005\u0005\b!EQB\u0001G\u00011%I2\u0001\u0003\u0003\u000e\u0003aMQ%\u0003C\u0004\u0011)i!\u0001$\u0001\u0019\u000be\u0019\u0001\u0002B\u0007\u00021\u000f)C\u0002b\u0002\t\u00165\t\u0001dC\r\u0004\u0011\u0019i\u0011\u0001g\u0002\u001a\u0007!]Q\"\u0001\r\r"}, strings={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "()V", "collectEffectiveReferencedDescriptors", "", "result", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "descriptorToDeclaration", "Lcom/intellij/psi/PsiElement;", "findTopLevelParent", "declarationDescriptor", "getContainingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getEffectiveReferencedDescriptors", "", "getSourceFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getSourceFromDescriptor", "isTopLevelMainFunction", "", "mainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;"}, moduleName="kotlin-compiler")
public final class DescriptorToSourceUtils {
    public static final DescriptorToSourceUtils INSTANCE;
    public static final DescriptorToSourceUtils INSTANCE$;

    private final void collectEffectiveReferencedDescriptors(List<DeclarationDescriptor> result2, DeclarationDescriptor descriptor2) {
        CallableMemberDescriptor.Kind kind;
        if (descriptor2 instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)(kind = ((CallableMemberDescriptor)descriptor2).getKind()), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true && Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.SYNTHESIZED) ^ true) {
            for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
                DeclarationDescriptor declarationDescriptor = callableMemberDescriptor.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "overridden.getOriginal()");
                this.collectEffectiveReferencedDescriptors(result2, declarationDescriptor);
            }
            return;
        }
        result2.add(descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DeclarationDescriptor> getEffectiveReferencedDescriptors(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ArrayList result2 = new ArrayList();
        List list = result2;
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.getOriginal()");
        INSTANCE.collectEffectiveReferencedDescriptors(list, declarationDescriptor);
        return result2;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getSourceFromDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithSource)) {
            declarationDescriptor = null;
        }
        return (object = (DeclarationDescriptorWithSource)declarationDescriptor) != null && (object = object.getSource()) != null ? KotlinSourceElementKt.getPsi((SourceElement)object) : null;
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry getSourceFromAnnotation(@NotNull AnnotationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        PsiElement psiElement2 = KotlinSourceElementKt.getPsi(descriptor2.getSource());
        if (!(psiElement2 instanceof KtAnnotationEntry)) {
            psiElement2 = null;
        }
        return (KtAnnotationEntry)psiElement2;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        PsiElement psiElement2;
        Collection<DeclarationDescriptor> effectiveReferencedDescriptors;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Collection<DeclarationDescriptor> $receiver = effectiveReferencedDescriptors = DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor2);
        if ($receiver.size() == 1) {
            Object t = CollectionsKt.firstOrNull((Iterable)effectiveReferencedDescriptors);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)t);
        } else {
            psiElement2 = null;
        }
        return psiElement2;
    }

    @JvmStatic
    @Nullable
    public static final KtFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        DeclarationDescriptor declarationDescriptor2 = INSTANCE.findTopLevelParent(declarationDescriptor);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor2;
        PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement declaration = psiElement2;
        PsiFile psiFile = declaration.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    @JvmStatic
    public static final boolean isTopLevelMainFunction(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull MainFunctionDetector mainFunctionDetector) {
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        Intrinsics.checkParameterIsNotNull(mainFunctionDetector, "mainFunctionDetector");
        if (!(declarationDescriptor instanceof FunctionDescriptor) || !DescriptorUtils.isTopLevelDeclaration(declarationDescriptor) || Intrinsics.areEqual(((FunctionDescriptor)declarationDescriptor).getName().asString(), "main") ^ true) {
            return false;
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
        return element instanceof KtNamedFunction && mainFunctionDetector.isMain((KtNamedFunction)element);
    }

    private final DeclarationDescriptor findTopLevelParent(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
            }
            descriptor2 = ((PropertyAccessorDescriptor)declarationDescriptor2).getCorrespondingProperty();
        }
        while (descriptor2 != null && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return descriptor2;
    }

    static {
        new DescriptorToSourceUtils();
    }

    private DescriptorToSourceUtils() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

