/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015\"Ba\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\r\u0015\nB!\u0001E\u0007\u001b\u0005A\"!F\u0001\u0019\u000fe%\u0001rB\u0007\u00021!\u00016\u0011AM\u0005\u0011\u0013i\u0011\u0001G\u0003Q\u0007\u0005\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;"}, moduleName="kotlin-compiler")
public final class InlineParameterChecker
implements DeclarationChecker {
    public static final InlineParameterChecker INSTANCE;
    public static final InlineParameterChecker INSTANCE$;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (declaration instanceof KtFunction) {
            boolean inline = ((KtFunction)declaration).hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration).getValueParameters()) {
                VariableDescriptor parameterDescriptor = (VariableDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER, parameter);
                if (inline && (parameterDescriptor == null || KotlinBuiltIns.isFunctionOrExtensionFunctionType(parameterDescriptor.getType()))) continue;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.NOINLINE_KEYWORD");
                this.reportIncorrectInline(parameter, ktModifierKeywordToken, diagnosticHolder);
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "KtTokens.CROSSINLINE_KEYWORD");
                this.reportIncorrectInline(parameter, ktModifierKeywordToken2, diagnosticHolder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIncorrectInline(KtParameter $receiver, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        Unit unit;
        PsiElement modifier;
        KtModifierList ktModifierList = $receiver.getModifierList();
        PsiElement psiElement2 = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
        if (psiElement2 != null) {
            void $receiver2;
            PsiElement psiElement3 = psiElement2;
            PsiElement it = (PsiElement)$receiver2;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    static {
        new InlineParameterChecker();
    }

    private InlineParameterChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

