/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMember;

public class SignaturesUtil {
    private SignaturesUtil() {
    }

    @Nullable
    public static String getKotlinSignature(@NotNull JavaMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        JavaAnnotation newAnnotation = member.findAnnotation(JvmAnnotationNames.KOTLIN_SIGNATURE);
        if (newAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(newAnnotation);
        }
        JavaAnnotation oldAnnotation = member.findAnnotation(JvmAnnotationNames.OLD_KOTLIN_SIGNATURE);
        if (oldAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(oldAnnotation);
        }
        return null;
    }

    @Nullable
    private static String extractKotlinSignatureArgument(@NotNull JavaAnnotation annotation2) {
        Object value2;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "extractKotlinSignatureArgument"));
        }
        JavaAnnotationArgument argument = annotation2.findArgument(JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME);
        if (argument instanceof JavaLiteralAnnotationArgument && (value2 = ((JavaLiteralAnnotationArgument)argument).getValue()) instanceof String) {
            return StringUtil.unescapeStringCharacters((String)value2);
        }
        return null;
    }
}

