/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetObjectInfo;

public class JetClassInfoUtil {
    @NotNull
    public static JetClassLikeInfo createClassLikeInfo(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
        }
        if (classOrObject instanceof KtClass) {
            JetClassInfo jetClassInfo = new JetClassInfo((KtClass)classOrObject);
            if (jetClassInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
            }
            return jetClassInfo;
        }
        if (classOrObject instanceof KtObjectDeclaration) {
            JetObjectInfo jetObjectInfo = new JetObjectInfo((KtObjectDeclaration)classOrObject);
            if (jetObjectInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
            }
            return jetObjectInfo;
        }
        throw new IllegalArgumentException("Unknown declaration type: " + classOrObject + classOrObject.getText());
    }
}

