/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.FunctionLiteralArgument;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ControlStructureTypingUtils {
    private static final Logger LOG = Logger.getInstance(ControlStructureTypingUtils.class);
    private final CallResolver callResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final ModuleDescriptor moduleDescriptor;

    public ControlStructureTypingUtils(@NotNull CallResolver callResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull ModuleDescriptor moduleDescriptor) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "<init>"));
        }
        if (dataFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowAnalyzer", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "<init>"));
        }
        this.callResolver = callResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.moduleDescriptor = moduleDescriptor;
    }

    ResolvedCall<FunctionDescriptor> resolveSpecialConstructionAsCall(@NotNull Call call, @NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable, @NotNull ExpressionTypingContext context, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (construct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "construct", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (argumentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentNames", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (isArgumentNullable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isArgumentNullable", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        SimpleFunctionDescriptorImpl function = this.createFunctionDescriptorForSpecialConstruction(construct, argumentNames, isArgumentNullable);
        TracingStrategy tracing = this.createTracingForSpecialConstruction(call, construct.getName(), context);
        ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call, function);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCallWithKnownCandidate(call, tracing, context, resolutionCandidate, dataFlowInfoForArguments);
        assert (results.isSingleResult()) : "Not single result after resolving one known candidate";
        return results.getResultingCall();
    }

    private SimpleFunctionDescriptorImpl createFunctionDescriptorForSpecialConstruction(@NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable) {
        if (construct == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "construct", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        if (argumentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentNames", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        if (isArgumentNullable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isArgumentNullable", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        assert (argumentNames.size() == isArgumentNullable.size());
        String constructionName = construct.getName().toUpperCase();
        Name specialFunctionName = Name.identifier("<SPECIAL-FUNCTION-FOR-" + constructionName + "-RESOLVE>");
        SimpleFunctionDescriptorImpl function = SimpleFunctionDescriptorImpl.create(this.moduleDescriptor, Annotations.Companion.getEMPTY(), specialFunctionName, CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        TypeParameterDescriptor typeParameter = TypeParameterDescriptorImpl.createWithDefaultBound(function, Annotations.Companion.getEMPTY(), false, Variance.INVARIANT, Name.identifier("<TYPE-PARAMETER-FOR-" + constructionName + "-RESOLVE>"), 0);
        KotlinType type2 = typeParameter.getDefaultType();
        KotlinType nullableType = TypeUtils.makeNullable(type2);
        ArrayList<ValueParameterDescriptorImpl> valueParameters = new ArrayList<ValueParameterDescriptorImpl>(argumentNames.size());
        for (int i = 0; i < argumentNames.size(); ++i) {
            KotlinType argumentType = isArgumentNullable.get(i) != false ? nullableType : type2;
            ValueParameterDescriptorImpl valueParameter = new ValueParameterDescriptorImpl(function, null, i, Annotations.Companion.getEMPTY(), Name.identifier(argumentNames.get(i)), argumentType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters.add(valueParameter);
        }
        KotlinType returnType2 = construct != ResolveConstruct.ELVIS ? type2 : TypeUtilsKt.replaceAnnotations(type2, AnnotationsForResolveKt.getExactInAnnotations());
        function.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Lists.newArrayList(typeParameter), valueParameters, returnType2, Modality.FINAL, Visibilities.PUBLIC);
        return function;
    }

    static MutableDataFlowInfoForArguments createIndependentDataFlowInfoForArgumentsForCall(final Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap) {
        return new MutableDataFlowInfoForArguments(){
            private DataFlowInfo initialDataFlowInfo;

            @Override
            public void setInitialDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
                if (dataFlowInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "setInitialDataFlowInfo"));
                }
                this.initialDataFlowInfo = dataFlowInfo;
            }

            @Override
            public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
                if (valueArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "updateInfo"));
                }
                if (dataFlowInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "updateInfo"));
                }
            }

            @Override
            @NotNull
            public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
                if (valueArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "getInfo"));
                }
                DataFlowInfo dataFlowInfo = (DataFlowInfo)dataFlowInfoForArgumentsMap.get(valueArgument);
                if (dataFlowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "getInfo"));
                }
                return dataFlowInfo;
            }

            @Override
            @NotNull
            public DataFlowInfo getResultInfo() {
                DataFlowInfo dataFlowInfo = this.initialDataFlowInfo;
                if (dataFlowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1", "getResultInfo"));
                }
                return dataFlowInfo;
            }
        };
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsForIfCall(@NotNull Call callForIf, @NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
        if (callForIf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callForIf", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        if (thenInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        if (elseInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = Maps.newHashMap();
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(0), thenInfo);
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(1), elseInfo);
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(dataFlowInfoForArgumentsMap);
    }

    static Call createCallForSpecialConstruction(final @NotNull KtExpression expression, final @NotNull KtExpression calleeExpression, @NotNull List<? extends KtExpression> arguments2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createCallForSpecialConstruction"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createCallForSpecialConstruction"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createCallForSpecialConstruction"));
        }
        final ArrayList<ValueArgument> valueArguments2 = Lists.newArrayList();
        for (KtExpression ktExpression : arguments2) {
            valueArguments2.add(CallMaker.makeValueArgument(ktExpression));
        }
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return expression.getNode();
            }

            @Override
            @NotNull
            public ReceiverValue getExplicitReceiver() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getExplicitReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public ReceiverValue getDispatchReceiver() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getDispatchReceiver"));
                }
                return receiverValue;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return calleeExpression;
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list = valueArguments2;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getValueArguments"));
                }
                return list;
            }

            @NotNull
            public List<FunctionLiteralArgument> getFunctionLiteralArguments() {
                List<FunctionLiteralArgument> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getFunctionLiteralArguments"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getTypeArguments"));
                }
                return list;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtExpression ktExpression = expression;
                if (ktExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getCallElement"));
                }
                return ktExpression;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2", "getCallType"));
                }
                return callType;
            }
        };
    }

    @NotNull
    TracingStrategy createTracingForSpecialConstruction(final @NotNull Call call, @NotNull String constructionName, final @NotNull ExpressionTypingContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        if (constructionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructionName", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        class CheckTypeContext {
            public BindingTrace trace;
            public KotlinType expectedType;

            CheckTypeContext(@NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1CheckTypeContext", "<init>"));
                }
                if (expectedType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1CheckTypeContext", "<init>"));
                }
                this.trace = trace;
                this.expectedType = expectedType;
            }

            CheckTypeContext makeTypeNullable() {
                if (TypeUtils.noExpectedType(this.expectedType)) {
                    return this;
                }
                return new CheckTypeContext(this.trace, TypeUtils.makeNullable(this.expectedType));
            }
        }
        final KtVisitor<Boolean, CheckTypeContext> checkTypeVisitor = new KtVisitor<Boolean, CheckTypeContext>(){

            private boolean checkExpressionType(@NotNull KtExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "checkExpressionType"));
                }
                KotlinTypeInfo typeInfo = BindingContextUtils.getRecordedTypeInfo(expression, c.trace.getBindingContext());
                if (typeInfo == null) {
                    return false;
                }
                Ref<Boolean> hasError = Ref.create();
                ControlStructureTypingUtils.this.dataFlowAnalyzer.checkType(typeInfo.getType(), expression, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(c.expectedType)).replaceDataFlowInfo(typeInfo.getDataFlowInfo())).replaceBindingTrace(c.trace), hasError);
                return hasError.get();
            }

            private boolean checkExpressionTypeRecursively(@Nullable KtExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    return false;
                }
                return expression.accept(this, c);
            }

            private boolean checkSubExpressions(KtExpression firstSub, KtExpression secondSub, KtExpression expression, CheckTypeContext firstContext, CheckTypeContext secondContext, CheckTypeContext context2) {
                boolean errorWasReported = this.checkExpressionTypeRecursively(firstSub, firstContext);
                return (errorWasReported |= this.checkExpressionTypeRecursively(secondSub, secondContext)) || this.checkExpressionType(expression, context2);
            }

            @Override
            public Boolean visitIfExpression(@NotNull KtIfExpression ifExpression, CheckTypeContext c) {
                if (ifExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "visitIfExpression"));
                }
                KtExpression thenBranch = ifExpression.getThen();
                KtExpression elseBranch = ifExpression.getElse();
                if (thenBranch == null || elseBranch == null) {
                    return this.checkExpressionType(ifExpression, c);
                }
                return this.checkSubExpressions(thenBranch, elseBranch, ifExpression, c, c, c);
            }

            @Override
            public Boolean visitBlockExpression(@NotNull KtBlockExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "visitBlockExpression"));
                }
                if (expression.getStatements().isEmpty()) {
                    return this.checkExpressionType(expression, c);
                }
                KtExpression lastStatement = KtPsiUtil.getLastStatementInABlock(expression);
                if (lastStatement != null) {
                    return this.checkExpressionTypeRecursively(lastStatement, c);
                }
                return false;
            }

            @Override
            public Boolean visitPostfixExpression(@NotNull KtPostfixExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "visitPostfixExpression"));
                }
                if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
                    return this.checkExpressionTypeRecursively(expression.getBaseExpression(), c.makeTypeNullable());
                }
                return (Boolean)super.visitPostfixExpression(expression, c);
            }

            @Override
            public Boolean visitBinaryExpression(@NotNull KtBinaryExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "visitBinaryExpression"));
                }
                if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.ELVIS) {
                    return this.checkSubExpressions(expression.getLeft(), expression.getRight(), expression, c.makeTypeNullable(), c, c);
                }
                return (Boolean)super.visitBinaryExpression(expression, c);
            }

            @Override
            public Boolean visitExpression(@NotNull KtExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3", "visitExpression"));
                }
                return this.checkExpressionType(expression, c);
            }
        };
        ThrowingOnErrorTracingStrategy throwingOnErrorTracingStrategy = new ThrowingOnErrorTracingStrategy("resolve " + constructionName + " as a call"){

            @Override
            public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindReference"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindReference"));
                }
            }

            @Override
            public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindCall"));
                }
                if (call2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindCall"));
                }
                trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
            }

            @Override
            public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindResolvedCall"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "bindResolvedCall"));
                }
                trace.record(BindingContext.RESOLVED_CALL, call, resolvedCall);
            }

            @Override
            public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData data) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "typeInferenceFailed"));
                }
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$4", "typeInferenceFailed"));
                }
                ConstraintSystem constraintSystem = data.constraintSystem;
                ConstraintSystemStatus status = constraintSystem.getStatus();
                assert (!status.isSuccessful()) : "Report error only for not successful constraint system";
                if (status.hasErrorInConstrainingTypes() || status.hasUnknownParameters()) {
                    return;
                }
                KtExpression expression = (KtExpression)call.getCallElement();
                if (status.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION) || status.hasConflictingConstraints() || status.hasTypeInferenceIncorporationError()) {
                    expression.accept(checkTypeVisitor, new CheckTypeContext(trace, data.expectedType));
                    return;
                }
                KtDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, KtNamedDeclaration.class);
                this.logError("Expression: " + (parentDeclaration != null ? parentDeclaration.getText() : expression.getText()) + "\nConstraint system status: \n" + ConstraintsUtil.getDebugMessageForStatus(status));
            }
        };
        if (throwingOnErrorTracingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        return throwingOnErrorTracingStrategy;
    }

    private static abstract class ThrowingOnErrorTracingStrategy
    implements TracingStrategy {
        private final String debugName;

        protected ThrowingOnErrorTracingStrategy(String debugName) {
            this.debugName = debugName;
        }

        private void logError() {
            this.logError(null);
        }

        protected void logError(@Nullable String additionalInformation) {
            String errorMessage = "Resolution error of this type shouldn't occur for " + this.debugName;
            if (additionalInformation != null) {
                errorMessage = errorMessage + ".\n" + additionalInformation;
            }
            LOG.error(errorMessage);
        }

        @Override
        public void unresolvedReference(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReference"));
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReferenceWrongReceiver"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReferenceWrongReceiver"));
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "recordAmbiguity"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "recordAmbiguity"));
            }
            this.logError();
        }

        @Override
        public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "missingReceiver"));
            }
            if (expectedReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReceiver", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "missingReceiver"));
            }
            this.logError();
        }

        @Override
        public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            if (receiverParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            if (receiverArgument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            this.logError();
        }

        @Override
        public void noReceiverAllowed(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noReceiverAllowed"));
            }
            this.logError();
        }

        @Override
        public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noValueForParameter"));
            }
            if (valueParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noValueForParameter"));
            }
            this.logError();
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongNumberOfTypeArguments"));
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "ambiguity"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "ambiguity"));
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noneApplicable"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noneApplicable"));
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "cannotCompleteResolve"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "cannotCompleteResolve"));
            }
            this.logError();
        }

        @Override
        public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "instantiationOfAbstractClass"));
            }
            this.logError();
        }

        @Override
        public void abstractSuperCall(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "abstractSuperCall"));
            }
            this.logError();
        }

        @Override
        public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ExplicitReceiverKind explicitReceiverKind) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "nestedClassAccessViaInstanceReference"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "nestedClassAccessViaInstanceReference"));
            }
            if (explicitReceiverKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "nestedClassAccessViaInstanceReference"));
            }
            this.logError();
        }

        @Override
        public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unsafeCall"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unsafeCall"));
            }
            this.logError();
        }

        @Override
        public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unnecessarySafeCall"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unnecessarySafeCall"));
            }
            this.logError();
        }

        @Override
        public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "invisibleMember"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "invisibleMember"));
            }
            this.logError();
        }

        @Override
        public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData inferenceErrorData) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "typeInferenceFailed"));
            }
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceErrorData", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "typeInferenceFailed"));
            }
            this.logError();
        }

        @Override
        public void nonExtensionFunctionCalledAsExtension(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "nonExtensionFunctionCalledAsExtension"));
            }
            this.logError();
        }
    }

    public static enum ResolveConstruct {
        IF("if"),
        ELVIS("elvis"),
        EXCL_EXCL("ExclExcl");

        private final String name;

        private ResolveConstruct(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

