/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.CopiesPanel;

public class WorkingCopiesContent {
    private final SvnVcs myVcs;
    private Content myShownContent;

    public WorkingCopiesContent(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public void activate() {
        ChangesViewContentI cvcm = ChangesViewContentManager.getInstance((Project)this.myVcs.getProject());
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        CopiesPanel copiesPanel = new CopiesPanel(this.myVcs.getProject());
        this.myShownContent = contentFactory.createContent(copiesPanel.getComponent(), SvnBundle.message("dialog.show.svn.map.title", new Object[0]), true);
        this.myShownContent.setCloseable(false);
        cvcm.addContent(this.myShownContent);
        this.myShownContent.setPreferredFocusableComponent(copiesPanel.getPreferredFocusedComponent());
    }

    public void deactivate() {
        if (this.myShownContent != null) {
            ChangesViewContentI cvcm = ChangesViewContentManager.getInstance((Project)this.myVcs.getProject());
            cvcm.removeContent(this.myShownContent);
            this.myShownContent = null;
        }
    }

    public static void show(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/WorkingCopiesContent", "show"));
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        if (manager != null && (window = manager.getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID)) != null) {
            window.show(null);
            ContentManager cm = window.getContentManager();
            Content content = cm.findContent(SvnBundle.message("dialog.show.svn.map.title", new Object[0]));
            if (content != null) {
                cm.setSelectedContent(content, true);
            }
        }
    }
}

